/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.debug.goal;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.debug.goal.DebugGoal;
import codes.wasabi.xclaim.debug.writer.DebugWriter;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.util.metric.Metric;
import codes.wasabi.xclaim.util.metric.MetricFormatter;
import codes.wasabi.xclaim.util.metric.MetricSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class DebugGoalInstance {
    private static final int F_ASYNC = 1;
    private static final int F_ACCEPTS_WRITER = 2;
    private static final int F_RETURNS_VOID = 4;
    private static final MetricFormatter TIMESTAMP_FORMAT = new MetricFormatter(MetricSet.builder().upTo(Metric.UNIT).build());
    private final String label;
    private final Method method;
    private final byte flags;

    @NotNull
    public static @Unmodifiable List<DebugGoalInstance> findInClass(@NotNull Class<?> clazz) {
        List<DebugGoalInstance> ret;
        Method tmp;
        Method[] methods = clazz.getDeclaredMethods();
        int staticCount = 0;
        for (int i = 0; i < methods.length; ++i) {
            tmp = methods[i];
            if (!Modifier.isStatic(tmp.getModifiers())) continue;
            if (i != staticCount) {
                methods[staticCount] = tmp;
            }
            ++staticCount;
        }
        if (staticCount == 0) {
            return Collections.emptyList();
        }
        String labelBase = clazz.getSimpleName();
        DebugGoalInstance[] instances = new DebugGoalInstance[staticCount];
        int instanceCount = 0;
        for (int i = 0; i < staticCount; ++i) {
            tmp = methods[i];
            DebugGoal annotation = tmp.getAnnotation(DebugGoal.class);
            if (annotation == null) continue;
            try {
                tmp.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String label = labelBase + "." + tmp.getName();
            Class<?>[] params = tmp.getParameterTypes();
            boolean acceptsWriter = false;
            if (params.length != 0) {
                if (params.length == 1 && params[0].isAssignableFrom(DebugWriter.class)) {
                    acceptsWriter = true;
                } else {
                    XClaim.logger.log(Level.WARNING, "DebugGoal (" + label + ") has malformed signature");
                    continue;
                }
            }
            instances[instanceCount++] = new DebugGoalInstance(label, tmp, annotation.async(), acceptsWriter, tmp.getReturnType().equals(Void.TYPE));
        }
        if (instanceCount == 0) {
            return Collections.emptyList();
        }
        if (instanceCount < Math.floorDiv(staticCount * 3, 4)) {
            DebugGoalInstance[] cpy = new DebugGoalInstance[instanceCount];
            System.arraycopy(instances, 0, cpy, 0, instanceCount);
            ret = Arrays.asList(cpy);
        } else {
            ret = Arrays.asList(instances).subList(0, instanceCount);
        }
        return ret;
    }

    DebugGoalInstance(@NotNull String label, @NotNull Method method, boolean async, boolean acceptsWriter, boolean returnsVoid) {
        this.label = label;
        this.method = method;
        int flags = 0;
        if (async) {
            flags |= 1;
        }
        if (acceptsWriter) {
            flags |= 2;
        }
        if (returnsVoid) {
            flags |= 4;
        }
        this.flags = (byte)flags;
    }

    @NotNull
    public String label() {
        return this.label;
    }

    @NotNull
    public Method method() {
        return this.method;
    }

    public boolean async() {
        return (Byte.toUnsignedInt(this.flags) & 1) != 0;
    }

    public boolean acceptsWriter() {
        return (Byte.toUnsignedInt(this.flags) & 2) != 0;
    }

    public boolean returnsVoid() {
        return (Byte.toUnsignedInt(this.flags) & 4) != 0;
    }

    public void execute(@NotNull DebugWriter writer) {
        if (this.async()) {
            Platform.get().getScheduler().runTaskAsynchronously((Plugin)XClaim.instance, () -> this.execute0(writer));
        } else {
            this.execute0(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute0(@NotNull DebugWriter writer) {
        Object out;
        writer.color(NamedTextColor.WHITE);
        long start = System.nanoTime();
        try {
            out = this.execute00(writer);
        }
        catch (InvocationTargetException e1) {
            Throwable cause = e1.getCause();
            writer.raise(cause != null ? cause : e1);
            return;
        }
        catch (Throwable t) {
            writer.raise(t);
            return;
        }
        finally {
            long elapsed = System.nanoTime() - start;
            this.reportElapsed(writer, elapsed);
        }
        if (this.returnsVoid()) {
            return;
        }
        writer.color(NamedTextColor.GRAY);
        writer.println("> " + out);
    }

    private Object execute00(@NotNull DebugWriter writer) throws ReflectiveOperationException {
        Object[] objectArray;
        if (this.acceptsWriter()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = writer;
        } else {
            objectArray = new Object[]{};
        }
        Object[] args = objectArray;
        return this.method.invoke(null, args);
    }

    private void reportElapsed(@NotNull DebugWriter writer, long elapsed) {
        writer.color(NamedTextColor.DARK_GRAY);
        writer.println("> Done in " + TIMESTAMP_FORMAT.format((double)elapsed * 1.0E-9, "s"));
    }
}

