/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.config.impl.yaml.sub;

import codes.wasabi.xclaim.config.impl.yaml.YamlConfig;
import codes.wasabi.xclaim.config.impl.yaml.helpers.YamlLimits;
import codes.wasabi.xclaim.config.struct.helpers.ConfigComparators;
import codes.wasabi.xclaim.config.struct.sub.RulesConfig;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class YamlRulesConfig
extends YamlConfig
implements RulesConfig {
    private final YamlLimits limits;

    public YamlRulesConfig(@Nullable ConfigurationSection section, @Nullable YamlLimits limits) {
        super(section);
        this.limits = limits;
    }

    @Nullable
    private <T> T placementTriple(@NotNull T none, @NotNull T cardinal, @NotNull T neighbor) {
        Boolean f1 = this.getBoolean("enforce-adjacent-claim-chunks");
        if (f1 == null) {
            return null;
        }
        if (!f1.booleanValue()) {
            return none;
        }
        Boolean f2 = this.getBoolean("allow-diagonal-claim-chunks");
        if (f2 == null) {
            return null;
        }
        return f2 != false ? neighbor : cardinal;
    }

    @Override
    public @UnknownNullability Integer placementRaw() {
        return this.placementTriple(RulesConfig.PlacementRule.NONE.code(), RulesConfig.PlacementRule.CARDINAL.code(), RulesConfig.PlacementRule.NEIGHBOR.code());
    }

    @Override
    public @UnknownNullability RulesConfig.PlacementRule placement() {
        return this.placementTriple(RulesConfig.PlacementRule.NONE, RulesConfig.PlacementRule.CARDINAL, RulesConfig.PlacementRule.NEIGHBOR);
    }

    @Override
    public @UnknownNullability Integer minDistance() {
        return this.getInt("claim-min-distance");
    }

    @Override
    public @UnknownNullability Boolean exemptOwner() {
        return this.getBoolean("exempt-claim-owner-from-permission-rules");
    }

    @Override
    public @UnknownNullability Integer maxChunks(@Nullable Permissible target) {
        if (this.limits == null) {
            return null;
        }
        return this.limits.getInt(target, "max-chunks", ConfigComparators.INT_NATURAL_OR_INF);
    }

    @Override
    public @UnknownNullability Integer maxClaims(@Nullable Permissible target) {
        if (this.limits == null) {
            return null;
        }
        return this.limits.getInt(target, "max-claims", ConfigComparators.INT_NATURAL_OR_INF);
    }

    @Override
    public @UnknownNullability Integer maxClaimsInWorld(@Nullable Permissible target) {
        if (this.limits == null) {
            return null;
        }
        return this.limits.getInt(target, "max-claims-in-world", ConfigComparators.INT_NATURAL_OR_INF);
    }
}

