/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.config.impl.yaml.helpers;

import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongComparator;
import java.util.function.BiFunction;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class YamlLimits {
    @NotNull
    protected final ConfigurationSection section;

    @Contract(value="null -> null; !null -> new")
    public static YamlLimits of(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        return new YamlLimits(section);
    }

    public YamlLimits(@NotNull ConfigurationSection section) {
        this.section = section;
    }

    @Nullable
    private Long getLong(@Nullable Permissible target, @NotNull String key, @NotNull LongComparator cmp, @NotNull BiFunction<ConfigurationSection, String, Long> extractor) {
        long max = 0L;
        boolean any = false;
        for (String group : this.section.getKeys(false)) {
            ConfigurationSection sub;
            if (!this.inGroup(target, group) || (sub = this.section.getConfigurationSection(group)) == null || !sub.contains(key)) continue;
            long value = extractor.apply(sub, key);
            if (any) {
                if (cmp.compare(value, max) <= 0) continue;
                max = value;
                continue;
            }
            max = value;
            any = true;
        }
        return any ? Long.valueOf(max) : null;
    }

    @Nullable
    public Long getLong(@Nullable Permissible target, @NotNull String key, @NotNull LongComparator cmp) {
        return this.getLong(target, key, cmp, ConfigurationSection::getLong);
    }

    @Nullable
    public Integer getInt(@Nullable Permissible target, @NotNull String key, @NotNull IntComparator cmp) {
        Long l = this.getLong(target, key, new IntAsLongComparator(cmp), (a, b) -> a.getInt(b));
        if (l == null) {
            return null;
        }
        return l.intValue();
    }

    private boolean inGroup(@Nullable Permissible target, @NotNull String groupName) {
        if (groupName.equals("default")) {
            return true;
        }
        if (target == null) {
            return false;
        }
        if (target.isOp()) {
            return true;
        }
        return target.hasPermission("xclaim.group." + groupName);
    }

    private static final class IntAsLongComparator
    implements LongComparator {
        private final IntComparator backing;

        IntAsLongComparator(IntComparator backing) {
            this.backing = backing;
        }

        public int compare(long a, long b) {
            return this.backing.compare(Math.toIntExact(a), Math.toIntExact(b));
        }
    }
}

