/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.sub;

import codes.wasabi.xclaim.command.Command;
import codes.wasabi.xclaim.command.argument.Argument;
import codes.wasabi.xclaim.command.argument.type.ChoiceType;
import codes.wasabi.xclaim.command.argument.type.LazyType;
import codes.wasabi.xclaim.debug.Debug;
import codes.wasabi.xclaim.debug.goal.DebugGoalInstance;
import codes.wasabi.xclaim.debug.writer.DebugWriter;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.audience.Audience;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.util.ProxyList;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class DebugCommand
implements Command {
    private final Argument goalArg = new Argument(new LazyType(() -> new ChoiceType(new ProxyList<DebugGoalInstance, String>(Debug.getGoals(), DebugGoalInstance::label))), "goal", "");

    @Override
    @NotNull
    public String getName() {
        return "debug";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "";
    }

    @Override
    @NotNull
    public @NotNull Argument @NotNull [] getArguments() {
        return new Argument[]{this.goalArg};
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFL) int getNumRequiredArguments() {
        return 1;
    }

    @Override
    public boolean requiresPlayerExecutor() {
        return false;
    }

    @Override
    public void execute(@NotNull CommandSender sender, Object ... arguments) throws Exception {
        String label = (String)arguments[0];
        DebugGoalInstance goal = Debug.getGoalByLabel(label);
        Audience audience = Platform.getAdventure().sender(sender);
        if (goal == null) {
            audience.sendMessage(Component.text("* Invalid goal").color(NamedTextColor.RED));
            return;
        }
        goal.execute(DebugWriter.of(audience));
    }
}

