/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.argument.type;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Type<T> {
    @NotNull
    public static <T> Type<T> auto(@NotNull Class<T> clazz) throws IllegalArgumentException {
        return Type.auto(clazz, clazz.getSimpleName());
    }

    @NotNull
    public static <T> Type<T> auto(final @NotNull Class<T> clazz, final @NotNull String name) throws IllegalArgumentException {
        Method method = null;
        for (Method m : clazz.getDeclaredMethods()) {
            Parameter param;
            Parameter[] params;
            if ((m.getModifiers() & 8) == 0 || !clazz.isAssignableFrom(m.getReturnType()) || (params = m.getParameters()).length != 1 || !(param = params[0]).getType().equals(String.class)) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new IllegalArgumentException("Cannot find suitable string parser method for " + clazz.getName());
        }
        final Method finalMethod = method;
        return new Type<T>(){

            @Override
            @NotNull
            public Class<T> getTypeClass() {
                return clazz;
            }

            @Override
            @NotNull
            public String getTypeName() {
                return name;
            }

            @Override
            @NotNull
            protected T convert(@NotNull String string) throws Exception {
                Object ob = finalMethod.invoke(null, string);
                return clazz.cast(ob);
            }
        };
    }

    @NotNull
    public abstract Class<T> getTypeClass();

    @NotNull
    public String getTypeName() {
        return this.getTypeClass().getSimpleName();
    }

    @NotNull
    public Collection<String> getSampleValues() {
        return Collections.emptyList();
    }

    @NotNull
    protected abstract T convert(@NotNull String var1) throws Exception;

    protected boolean validate(@NotNull T value) {
        return true;
    }

    @NotNull
    public final T parse(@NotNull String string) throws IllegalArgumentException {
        T ret;
        try {
            ret = this.convert(string);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (!this.validate(ret)) {
            throw new IllegalArgumentException("Argument does not meet special requirements for argument type " + this.getClass().getName());
        }
        return ret;
    }

    @Nullable
    public final T parseElseNull(@NotNull String string) {
        try {
            return this.parse(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

