/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.argument.type;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.command.argument.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RangeType
extends Type<Integer> {
    private final int f;
    private final int t;
    private final int radix;
    private final List<String> sampleValues;

    public RangeType(int from, int to, int radix) {
        this.f = Math.min(from, to);
        this.t = Math.max(from, to);
        this.radix = radix;
        this.sampleValues = new ArrayList<String>();
        for (int i = this.f; i <= this.t; ++i) {
            this.sampleValues.add(Integer.toString(i, radix));
        }
    }

    public RangeType(int from, int to) {
        this(from, to, 10);
    }

    @Override
    @NotNull
    public Class<Integer> getTypeClass() {
        return Integer.class;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return XClaim.lang.get("arg-range-name", this.sampleValues.get(0), this.sampleValues.get(this.sampleValues.size() - 1));
    }

    @Override
    @NotNull
    public Collection<String> getSampleValues() {
        return this.sampleValues;
    }

    @Override
    @NotNull
    protected Integer convert(@NotNull String string) {
        return Integer.valueOf(string, this.radix);
    }

    @Override
    protected boolean validate(@NotNull Integer value) {
        return this.f <= value && value <= this.t;
    }
}

