/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.argument.type;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.command.argument.type.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class OfflinePlayerType
extends Type<OfflinePlayer> {
    private static OfflinePlayer[] offlinePlayers = new OfflinePlayer[0];
    private static PlayerUpdateListener listener = null;

    public static boolean initializeListener() {
        if (listener != null) {
            return false;
        }
        offlinePlayers = Bukkit.getOfflinePlayers();
        listener = new PlayerUpdateListener();
        Bukkit.getPluginManager().registerEvents((Listener)listener, (Plugin)XClaim.instance);
        return true;
    }

    public static boolean clearListener() {
        if (listener == null) {
            return false;
        }
        HandlerList.unregisterAll((Listener)listener);
        listener = null;
        return true;
    }

    @Override
    @NotNull
    public Class<OfflinePlayer> getTypeClass() {
        return OfflinePlayer.class;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return XClaim.lang.get("arg-offlinePlayer-name");
    }

    @Override
    @NotNull
    public Collection<String> getSampleValues() {
        HashSet<String> ret = new HashSet<String>();
        for (OfflinePlayer op : offlinePlayers) {
            String name = op.getName();
            if (name == null) continue;
            ret.add(name);
        }
        return ret;
    }

    @Override
    @NotNull
    protected OfflinePlayer convert(@NotNull String string) throws NullPointerException {
        OfflinePlayer uncased = null;
        for (OfflinePlayer ply : offlinePlayers) {
            String name = ply.getName();
            if (name == null || !name.equalsIgnoreCase(string)) continue;
            uncased = ply;
            if (!name.equals(string)) continue;
            return ply;
        }
        return Objects.requireNonNull(uncased);
    }

    static /* synthetic */ OfflinePlayer[] access$002(OfflinePlayer[] x0) {
        offlinePlayers = x0;
        return x0;
    }

    public static class PlayerUpdateListener
    implements Listener {
        @EventHandler
        public void onJoin(@NotNull PlayerLoginEvent event) {
            Player ply = event.getPlayer();
            if (!ply.hasPlayedBefore()) {
                OfflinePlayer[] newOfflinePlayers = new OfflinePlayer[offlinePlayers.length + 1];
                System.arraycopy(offlinePlayers, 0, newOfflinePlayers, 1, offlinePlayers.length);
                newOfflinePlayers[0] = ply;
                OfflinePlayerType.access$002(newOfflinePlayers);
            }
        }
    }
}

