/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.argument.type;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.command.argument.type.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IntType
extends Type<Integer> {
    private final int radix;
    private final List<String> sampleValues;

    public IntType(int radix) {
        this.radix = radix;
        this.sampleValues = Arrays.asList(Integer.toString(0, radix), Integer.toString(1, radix));
    }

    public IntType() {
        this(10);
    }

    @Override
    @NotNull
    public Class<Integer> getTypeClass() {
        return Integer.class;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return XClaim.lang.get("arg-int-name");
    }

    @Override
    @NotNull
    public Collection<String> getSampleValues() {
        return this.sampleValues;
    }

    @Override
    @NotNull
    protected Integer convert(@NotNull String string) throws NumberFormatException {
        return Integer.valueOf(string, this.radix);
    }
}

