/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.command.Command;
import codes.wasabi.xclaim.command.argument.Argument;
import codes.wasabi.xclaim.command.sub.ChunksCommand;
import codes.wasabi.xclaim.command.sub.ClearCommand;
import codes.wasabi.xclaim.command.sub.CurrentCommand;
import codes.wasabi.xclaim.command.sub.DebugCommand;
import codes.wasabi.xclaim.command.sub.GUICommand;
import codes.wasabi.xclaim.command.sub.HelpCommand;
import codes.wasabi.xclaim.command.sub.InfoCommand;
import codes.wasabi.xclaim.command.sub.ListCommand;
import codes.wasabi.xclaim.command.sub.RestartCommand;
import codes.wasabi.xclaim.command.sub.UpdateCommand;
import codes.wasabi.xclaim.debug.Debug;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XClaimCommand
implements Command {
    private final Collection<Command> subCommands;
    private final Command guiCommmand;
    private final Argument[] args = new Argument[0];

    public XClaimCommand() {
        this.guiCommmand = new GUICommand();
        HelpCommand helpCommand = new HelpCommand();
        this.subCommands = XClaimCommand.allocateSubCommands(helpCommand, this.guiCommmand);
        helpCommand.setCommands(this.subCommands);
    }

    @NotNull
    private static List<Command> allocateSubCommands(HelpCommand help, Command gui) {
        Command[] sub = new Command[]{help, gui, new InfoCommand(), new CurrentCommand(), new UpdateCommand(), new RestartCommand(), new ChunksCommand(), new ClearCommand(), new ListCommand(), new DebugCommand()};
        List<Command> ret = Arrays.asList(sub);
        if (!Debug.isEnabled()) {
            ret = ret.subList(0, ret.size() - 1);
        }
        return ret;
    }

    @Override
    @NotNull
    public String getName() {
        return "xclaim";
    }

    @Override
    @NotNull
    public String getDescription() {
        return XClaim.lang.get("cmd-xc-description");
    }

    @Override
    @NotNull
    public @NotNull Argument @NotNull [] getArguments() {
        return this.args;
    }

    @Override
    public int getNumRequiredArguments() {
        return 0;
    }

    @Override
    public boolean requiresPlayerExecutor() {
        return true;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String alias, Object ... arguments) throws Exception {
        this.guiCommmand.execute(sender, alias, arguments);
    }

    @Override
    @Nullable
    public Collection<Command> getSubCommands() {
        return this.subCommands;
    }
}

