/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.command.Command;
import codes.wasabi.xclaim.command.argument.Argument;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.audience.Audience;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class CommandManager {
    private final Map<String, Handler> map = new HashMap<String, Handler>();

    public void register(@NotNull Command command) {
        Handler handler;
        PluginCommand bukkitCmd;
        String name = command.getName();
        if (this.map.containsKey(name)) {
            this.unregister(command);
        }
        if ((bukkitCmd = (handler = new Handler(command)).bukkitCmd) == null) {
            XClaim.logger.warning(XClaim.lang.get("cmdmgr-err-undefined", name));
            return;
        }
        bukkitCmd.setExecutor((CommandExecutor)handler);
        bukkitCmd.setTabCompleter((TabCompleter)handler);
        bukkitCmd.setDescription(command.getDescription());
        this.map.put(name, new Handler(command));
    }

    public void unregister(@NotNull Command command) {
        Handler handler = this.map.remove(command.getName());
        if (handler != null) {
            PluginCommand bukkitCmd = handler.bukkitCmd;
            if (bukkitCmd == null) {
                return;
            }
            bukkitCmd.setExecutor(null);
            bukkitCmd.setTabCompleter(null);
        }
    }

    private void unregister(Collection<org.bukkit.command.Command> commands) {
        try {
            Map known;
            Server server = Bukkit.getServer();
            Class clazz = server.getClass();
            Field f = null;
            try {
                f = clazz.getDeclaredField("commandMap");
            }
            catch (NoSuchFieldException e) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!CommandMap.class.isAssignableFrom(field.getDeclaringClass())) continue;
                    f = field;
                    break;
                }
            }
            Objects.requireNonNull(f);
            f.setAccessible(true);
            CommandMap cm = (CommandMap)f.get(server);
            Class clazz1 = cm.getClass();
            try {
                Method m = clazz1.getMethod("getKnownCommands", new Class[0]);
                known = (Map)m.invoke((Object)cm, new Object[0]);
            }
            catch (ClassCastException | NullPointerException | ReflectiveOperationException | SecurityException e) {
                Field f1 = clazz1.getDeclaredField("knownCommands");
                f1.setAccessible(true);
                known = (Map)f1.get(cm);
            }
            block7: for (Map.Entry entry : new HashSet(known.entrySet())) {
                String key = (String)entry.getKey();
                org.bukkit.command.Command value = (org.bukkit.command.Command)entry.getValue();
                for (org.bukkit.command.Command cmd : commands) {
                    if (!Objects.equals(cmd, value)) continue;
                    known.remove(key);
                    continue block7;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregisterAll() {
        ArrayList<org.bukkit.command.Command> commands = new ArrayList<org.bukkit.command.Command>();
        for (String cmd : new HashSet<String>(this.map.keySet())) {
            Handler handler = this.map.remove(cmd);
            if (handler == null) continue;
            PluginCommand bukkitCmd = handler.bukkitCmd;
            if (bukkitCmd == null) {
                return;
            }
            bukkitCmd.setExecutor(null);
            bukkitCmd.setTabCompleter(null);
            commands.add((org.bukkit.command.Command)bukkitCmd);
        }
        this.unregister(commands);
    }

    public void registerDefaults() {
        Reflections reflections = new Reflections("codes.wasabi.xclaim.command", new Scanner[0]);
        Set<Class<Command>> set = reflections.getSubTypesOf(Command.class);
        for (Class<Command> clazz : set) {
            Command com;
            Constructor<Command> con;
            Package p;
            int mod = clazz.getModifiers();
            if (Modifier.isAbstract(mod) || Modifier.isInterface(mod) || (p = clazz.getPackage()) != null && p.getName().contains("sub")) continue;
            try {
                con = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            try {
                con.setAccessible(true);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                com = con.newInstance(new Object[0]);
            }
            catch (IllegalAccessException e) {
                XClaim.logger.warning(XClaim.lang.get("cmdmgr-err-reflect", clazz.getName()));
                e.printStackTrace();
                continue;
            }
            catch (ReflectiveOperationException e) {
                continue;
            }
            this.register(com);
        }
    }

    public static class Handler
    implements CommandExecutor,
    TabCompleter {
        private final Command cmd;
        private final PluginCommand bukkitCmd;

        private Handler(@NotNull Command command) {
            this.cmd = command;
            this.bukkitCmd = XClaim.instance.getCommand(command.getName());
        }

        private Resolution resolveSubcommands(@NotNull Command root, @NotNull String[] args) {
            boolean fullyResolved;
            Command cmd = root;
            block0: do {
                fullyResolved = true;
                if (args.length < 1) continue;
                String n = args[0];
                Collection<Command> sub = cmd.getSubCommands();
                if (sub == null) continue;
                for (Command candidate : sub) {
                    if (!n.equalsIgnoreCase(candidate.getName())) continue;
                    cmd = candidate;
                    String[] newArgs = new String[args.length - 1];
                    if (newArgs.length > 0) {
                        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                    }
                    args = newArgs;
                    fullyResolved = false;
                    continue block0;
                }
            } while (!fullyResolved);
            return new Resolution(cmd, args);
        }

        public boolean onCommand(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command command, @NotNull String label, @NotNull String[] args) {
            int i;
            if (!Objects.equals(command, this.bukkitCmd)) {
                return false;
            }
            Audience audience = Platform.getAdventure().sender(sender);
            Resolution res = this.resolveSubcommands(this.cmd, args);
            Command cmd = res.cmd();
            args = res.args();
            if (cmd.requiresPlayerExecutor() && !(sender instanceof Player)) {
                audience.sendMessage(XClaim.lang.getComponent("cmdmgr-err-player"));
                return true;
            }
            Argument[] argDefs = cmd.getArguments();
            int len = args.length;
            int required = cmd.getNumRequiredArguments();
            if (len < required) {
                audience.sendMessage(XClaim.lang.getComponent("cmdmgr-err-min-args", required));
                return true;
            }
            if (len > argDefs.length) {
                audience.sendMessage(XClaim.lang.getComponent("cmdmgr-err-max-args", argDefs.length));
                return true;
            }
            Object[] obs = new Object[argDefs.length];
            try {
                for (i = 0; i < len; ++i) {
                    Argument def = argDefs[i];
                    String arg = args[i];
                    obs[i] = def.type().parse(arg);
                }
            }
            catch (IllegalArgumentException e) {
                audience.sendMessage(XClaim.lang.getComponent("cmdmgr-err-malformed"));
                return true;
            }
            for (i = len; i < argDefs.length; ++i) {
                obs[i] = null;
            }
            try {
                cmd.execute(sender, label, obs);
            }
            catch (Exception e) {
                audience.sendMessage(XClaim.lang.getComponent("cmdmgr-err-unexpected", e.getClass().getName()));
                e.printStackTrace();
            }
            return true;
        }

        @Nullable
        public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command command, @NotNull String alias, @NotNull String[] args) {
            Collection<Command> sub;
            if (!Objects.equals(command, this.bukkitCmd)) {
                return null;
            }
            Resolution res = this.resolveSubcommands(this.cmd, args);
            Command cmd = res.cmd();
            args = res.args();
            ArrayList<String> entries = new ArrayList<String>();
            int idx = Math.max(args.length - 1, 0);
            Argument[] argDefs = cmd.getArguments();
            String tail = "";
            LevenshteinDistance sd = LevenshteinDistance.getDefaultInstance();
            if (idx < argDefs.length) {
                Argument arg = argDefs[idx];
                tail = args.length == 0 ? "" : args[idx];
                entries.addAll(arg.type().getSampleValues());
            }
            if (idx == 0 && (sub = cmd.getSubCommands()) != null) {
                for (Command c : sub) {
                    entries.add(c.getName());
                }
            }
            String finalTail = tail;
            return entries.stream().sorted(Comparator.comparingInt(s -> sd.apply(finalTail, (CharSequence)s)).reversed()).collect(Collectors.toList());
        }

        @NotNull
        public Command getCommand() {
            return this.cmd;
        }

        @Nullable
        public PluginCommand getBukkitCommand() {
            return this.bukkitCmd;
        }

        private static class Resolution {
            private final Command cmd;
            private final String[] args;

            Resolution(@NotNull Command cmd, @NotNull String[] args) {
                this.cmd = cmd;
                this.args = args;
            }

            @NotNull
            Command cmd() {
                return this.cmd;
            }

            @NotNull
            String[] args() {
                return this.args;
            }
        }
    }
}

