/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.api.event;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.audience.Audience;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public abstract class XClaimEvent
extends Event
implements Cancellable {
    protected boolean cancelled = false;
    protected List<String> cancelMessages = new ArrayList<String>(1);

    @ApiStatus.Internal
    public static boolean dispatch(@NotNull XClaimEvent event, @NotNull Player player) {
        Component failMessage;
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.cancelled) {
            return true;
        }
        String langFailMessage = event.getTranslatableFailMessage();
        List<String> detail = event.cancelMessages;
        Component component = failMessage = XClaim.lang.has(langFailMessage) ? XClaim.lang.getComponent(langFailMessage) : null;
        if (!detail.isEmpty() && XClaim.lang.has(langFailMessage + "-single")) {
            failMessage = XClaim.lang.getComponent(langFailMessage + "-single", detail.get(0));
        }
        if (detail.size() > 1 && XClaim.lang.has(langFailMessage + "-multi")) {
            failMessage = XClaim.lang.getComponent(langFailMessage + "-multi", String.join((CharSequence)", ", detail));
        }
        Audience audience = Platform.getAdventure().player(player);
        if (failMessage != null) {
            audience.sendMessage(failMessage);
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean dispatch(@NotNull XClaimEvent event) throws UnsupportedOperationException {
        return XClaimEvent.dispatch(event, event.getPlayer());
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @ApiStatus.Obsolete
    public void setCancelled(boolean b) {
        this.cancelled = b;
    }

    public void cancel(@Nullable String cancelMessage) {
        this.cancelMessages.add(cancelMessage);
        this.cancelled = true;
    }

    @NotNull
    public @UnmodifiableView List<String> getCancelMessages() {
        return Collections.unmodifiableList(this.cancelMessages);
    }

    @NotNull
    protected abstract String getTranslatableFailMessage();

    @NotNull
    protected Player getPlayer() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Event has no associated Player");
    }
}

