/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.api.enums.permission.handler;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.api.enums.permission.PermissionHandler;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.platform.PlatformEntityPlaceListener;
import codes.wasabi.xclaim.shadow.paperlib.PaperLib;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class InteractHandler
extends PermissionHandler {
    private final Mode mode;
    private PlatformEntityPlaceListener entityPlaceListener = null;
    private final String[] legacyContainerClassNames = new String[]{"org.bukkit.block.Beacon", "org.bukkit.block.BrewingStand", "org.bukkit.block.Chest", "org.bukkit.block.Dispenser", "org.bukkit.block.Dropper", "org.bukkit.block.Furnace", "org.bukkit.block.Hopper", "org.bukkit.block.ShulkerBox"};
    private Class<?>[] legacyContainerClasses = null;

    public InteractHandler(@NotNull Claim claim, @NotNull Mode operationMode) {
        super(claim);
        this.mode = operationMode;
    }

    public InteractHandler(@NotNull Claim claim) {
        this(claim, Mode.ALL);
    }

    @Override
    protected void onRegister() {
        Class<Event> itemFrameEventClass;
        if (this.mode.equals((Object)Mode.PLACE_ENTS) || this.mode.equals((Object)Mode.PLACE_MOBILES)) {
            this.entityPlaceListener = Platform.get().getPlaceListener();
            if (this.entityPlaceListener != null) {
                this.entityPlaceListener.on(this::onPlaceEntity);
            }
        }
        if (!this.mode.equals((Object)Mode.ALL)) {
            return;
        }
        try {
            itemFrameEventClass = Class.forName("io.papermc.paper.event.player.PlayerItemFrameChangeEvent").asSubclass(Event.class);
        }
        catch (ClassCastException | ClassNotFoundException ignored) {
            return;
        }
        Bukkit.getPluginManager().registerEvent(itemFrameEventClass, (Listener)this, EventPriority.NORMAL, this::onPaperItemFrameChange, (Plugin)XClaim.instance);
    }

    @Override
    protected void onUnregister() {
        if (this.entityPlaceListener != null) {
            this.entityPlaceListener.unregister();
        }
    }

    private <T extends PlayerEvent> boolean itemCheck(@NotNull T event) {
        ItemStack is;
        Player ply = event.getPlayer();
        Location loc = ply.getLocation();
        if (event instanceof PlayerInteractEvent) {
            PlayerInteractEvent pie = (PlayerInteractEvent)event;
            EquipmentSlot slot = Platform.get().getInteractHand(pie);
            if (slot == null) {
                return false;
            }
            is = Platform.get().playerInventoryGetItem(ply.getInventory(), slot);
            Block block = pie.getClickedBlock();
            if (block != null) {
                loc = Platform.get().toCenterLocation(block.getRelative(pie.getBlockFace()).getLocation());
            }
        } else {
            is = Platform.get().getPlayerItemInUse(ply);
            if (event instanceof PlayerInteractEntityEvent) {
                loc = ((PlayerInteractEntityEvent)event).getRightClicked().getLocation();
            }
        }
        if (is == null) {
            return false;
        }
        Material mat = is.getType();
        if (this.mode.equals((Object)Mode.FLAMMABLE)) {
            if (!this.getClaim().contains(loc)) {
                return false;
            }
            boolean isFireCharge = false;
            Platform p = Platform.get();
            if (p.hasFireChargeMaterial()) {
                isFireCharge = mat.equals((Object)p.getFireChargeMaterial());
            }
            if (mat.equals((Object)Material.FLINT_AND_STEEL) || isFireCharge) {
                ((Cancellable)event).setCancelled(true);
                this.stdError(ply);
                return true;
            }
        } else {
            Platform p;
            if (mat.equals((Object)Material.WRITTEN_BOOK)) {
                if (this.getClaim().contains(loc)) {
                    p = Platform.get();
                    if (p.supportsArtificialBookOpen()) {
                        ((Cancellable)event).setCancelled(true);
                        p.artificialBookOpen(ply, is);
                    } else if (ply.isSneaking()) {
                        ((Cancellable)event).setCancelled(true);
                        this.stdError(ply);
                    }
                }
                return true;
            }
            if (mat.equals((Object)Platform.get().getFireworkRocketMaterial()) && Platform.get().playerIsGliding(ply)) {
                p = Platform.get();
                if (this.getClaim().contains(loc) && p.supportsArtificalElytraBoost()) {
                    int i;
                    ((Cancellable)event).setCancelled(true);
                    p.artificialElytraBoost(ply, is);
                    PlayerInventory inv = ply.getInventory();
                    int size = inv.getSize();
                    for (i = 0; i < size; ++i) {
                        ItemStack sample = inv.getItem(i);
                        if (sample == null || !sample.getType().equals((Object)Platform.get().getFireworkRocketMaterial())) continue;
                        if (sample.getAmount() > 1) {
                            sample.setAmount(sample.getAmount() - 1);
                            inv.setItem(i, sample);
                            break;
                        }
                        inv.setItem(i, null);
                        break;
                    }
                    if (i == size) {
                        inv.remove(Platform.get().getFireworkRocketMaterial());
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean legacyIsContainer(BlockState bs) {
        if (this.legacyContainerClasses == null) {
            Class[] classes = new Class[this.legacyContainerClassNames.length];
            int classCount = 0;
            for (String cn : this.legacyContainerClassNames) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(cn);
                }
                catch (Exception ignored) {
                    continue;
                }
                classes[classCount++] = clazz;
            }
            if (classCount < classes.length) {
                Class[] cpy = new Class[classCount];
                System.arraycopy(classes, 0, cpy, 0, classCount);
                classes = cpy;
            }
            this.legacyContainerClasses = classes;
        }
        for (Class<?> c : this.legacyContainerClasses) {
            if (!c.isInstance(bs)) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void onInteract(@NotNull PlayerInteractEvent event) {
        if (this.mode == Mode.CHESTS) {
            Block block = event.getClickedBlock();
            if (block != null) {
                BlockState bs = block.getState();
                boolean isContainer = PaperLib.isVersion(12, 2) ? bs instanceof Container : this.legacyIsContainer(bs);
                if (isContainer) {
                    Player ply = event.getPlayer();
                    if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.CHEST_OPEN)) {
                        return;
                    }
                    if (this.test((Cancellable)event, Platform.get().toCenterLocation(block.getLocation()))) {
                        this.stdError(ply);
                    }
                }
            }
            return;
        }
        if (this.mode != Mode.ALL && this.mode != Mode.FLAMMABLE) {
            return;
        }
        Player ply = event.getPlayer();
        if (this.mode == Mode.FLAMMABLE && this.getClaim().hasPermission((OfflinePlayer)ply, Permission.FIRE_USE)) {
            return;
        }
        if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.INTERACT)) {
            return;
        }
        if (this.itemCheck(event)) {
            return;
        }
        Location loc = Platform.get().getInteractionPoint(event);
        if (loc == null) {
            Block b = event.getClickedBlock();
            loc = b != null ? Platform.get().toCenterLocation(b.getLocation()) : event.getPlayer().getLocation();
        }
        if (this.test((Cancellable)event, loc)) {
            this.stdError(ply);
        }
    }

    @EventHandler
    public void onInteract(@NotNull PlayerInteractEntityEvent event) {
        if (this.mode != Mode.ALL && this.mode != Mode.FLAMMABLE) {
            return;
        }
        Player ply = event.getPlayer();
        if (this.mode == Mode.FLAMMABLE && this.getClaim().hasPermission((OfflinePlayer)ply, Permission.FIRE_USE)) {
            return;
        }
        if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.INTERACT)) {
            return;
        }
        if (this.itemCheck(event)) {
            return;
        }
        if (this.test((Cancellable)event, event.getRightClicked().getLocation())) {
            this.stdError(ply);
        }
    }

    @EventHandler
    public void onInteract(@NotNull PlayerInteractAtEntityEvent event) {
        if (this.mode != Mode.ALL && this.mode != Mode.FLAMMABLE) {
            return;
        }
        Player ply = event.getPlayer();
        if (this.mode == Mode.FLAMMABLE && this.getClaim().hasPermission((OfflinePlayer)ply, Permission.FIRE_USE)) {
            return;
        }
        if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.INTERACT)) {
            return;
        }
        if (this.itemCheck(event)) {
            return;
        }
        if (this.test((Cancellable)event, event.getClickedPosition().toLocation(event.getRightClicked().getWorld()))) {
            this.stdError(ply);
        }
    }

    @EventHandler
    public void onOpenChest(@NotNull InventoryOpenEvent event) {
        if (!this.mode.equals((Object)Mode.CHESTS)) {
            return;
        }
        HumanEntity ent = event.getPlayer();
        if (ent instanceof Player) {
            Player ply = (Player)ent;
            if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.CHEST_OPEN)) {
                return;
            }
            Inventory inv = event.getInventory();
            InventoryHolder holder = inv.getHolder();
            if (holder instanceof Container) {
                Block b;
                try {
                    b = ((Container)holder).getBlock();
                }
                catch (IllegalStateException ignored) {
                    return;
                }
                Location loc = Platform.get().toCenterLocation(b.getLocation());
                if (this.getClaim().contains(loc)) {
                    event.setCancelled(true);
                    this.stdError(ply);
                }
            }
        }
    }

    private void onPlaceEntity(@NotNull PlatformEntityPlaceListener.Data data) {
        if (!this.mode.equals((Object)Mode.PLACE_ENTS) && !this.mode.equals((Object)Mode.PLACE_MOBILES)) {
            return;
        }
        Player ply = data.player;
        if (ply == null) {
            return;
        }
        if (this.mode.equals((Object)Mode.PLACE_ENTS)) {
            if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.ENT_PLACE)) {
                return;
            }
        } else {
            if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.VEHICLE_PLACE)) {
                return;
            }
            if (!data.isVehicle) {
                return;
            }
        }
        if (this.getClaim().contains(data.location)) {
            data.cancel.run();
            this.stdError(ply);
        }
    }

    protected void onPaperItemFrameChange(Listener ignored, Event e1) {
        Location loc;
        Player ply = ((PlayerEvent)e1).getPlayer();
        if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.INTERACT)) {
            return;
        }
        Class<?> cls = e1.getClass();
        try {
            Method getItemFrameMethod = cls.getMethod("getItemFrame", new Class[0]);
            Entity itemFrame = (Entity)getItemFrameMethod.invoke((Object)e1, new Object[0]);
            loc = itemFrame.getLocation();
        }
        catch (ReflectiveOperationException | SecurityException ignored2) {
            loc = ply.getLocation();
        }
        if (this.test((Cancellable)e1, loc)) {
            this.stdError(ply);
        }
    }

    private boolean test(@NotNull Cancellable cancellable, @NotNull Location location) {
        if (this.getClaim().contains(location)) {
            cancellable.setCancelled(true);
            return true;
        }
        return false;
    }

    public static enum Mode {
        ALL,
        CHESTS,
        PLACE_ENTS,
        PLACE_MOBILES,
        FLAMMABLE;

    }

    public static class Flammable
    extends InteractHandler {
        public Flammable(@NotNull Claim claim) {
            super(claim, Mode.FLAMMABLE);
        }
    }

    public static class Vehicles
    extends InteractHandler {
        public Vehicles(@NotNull Claim claim) {
            super(claim, Mode.PLACE_MOBILES);
        }
    }

    public static class Entities
    extends InteractHandler {
        public Entities(@NotNull Claim claim) {
            super(claim, Mode.PLACE_ENTS);
        }
    }

    public static class Chests
    extends InteractHandler {
        public Chests(@NotNull Claim claim) {
            super(claim, Mode.CHESTS);
        }
    }
}

