/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.api.enums.permission.handler;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.api.enums.permission.PermissionHandler;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.platform.PlatformSchedulerTask;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class EnterHandler
extends PermissionHandler {
    private final Set<Player> occluding = new HashSet<Player>();
    private PlatformSchedulerTask task = null;

    public EnterHandler(@NotNull Claim claim) {
        super(claim);
    }

    @Override
    protected void onRegister() {
        this.occluding.clear();
        this.task = Platform.get().getScheduler().runTaskTimer((Plugin)XClaim.instance, () -> {
            for (Player ply : this.occluding) {
                ply.damage(2.0);
            }
        }, 0L, 5L);
    }

    @Override
    protected void onUnregister() {
        if (this.task == null) {
            return;
        }
        if (!this.task.isCancelled()) {
            this.task.cancel();
        }
    }

    @EventHandler
    public void onMove(@NotNull PlayerMoveEvent event) {
        boolean occ;
        Player ply = event.getPlayer();
        if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.ENTER)) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        boolean fromWithin = this.getClaim().contains(from);
        boolean toWithin = this.getClaim().contains(to);
        boolean bl = occ = toWithin && fromWithin;
        if (!occ) {
            this.occluding.remove(ply);
            if (toWithin) {
                event.setTo(from);
                event.setCancelled(true);
                this.stdError(ply);
            }
        } else {
            this.occluding.add(ply);
        }
    }
}

