/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.api.enums.permission.handler;

import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.api.enums.permission.PermissionHandler;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.paperlib.PaperLib;
import java.util.Arrays;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildBreakHandler
extends PermissionHandler {
    private final boolean place;
    private final boolean brk;

    public BuildBreakHandler(@NotNull Claim claim, boolean activateOnPlace, boolean activateOnBreak) {
        super(claim);
        this.place = activateOnPlace;
        this.brk = activateOnBreak;
    }

    @EventHandler
    public void onPlace(@NotNull BlockPlaceEvent event) {
        if (!this.place) {
            return;
        }
        if (this.getClaim().hasPermission((OfflinePlayer)event.getPlayer(), Permission.BUILD)) {
            return;
        }
        if (this.check((Cancellable)event, Platform.get().toCenterLocation(event.getBlock().getLocation()))) {
            this.stdError(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlace(@NotNull BlockMultiPlaceEvent event) {
        if (!this.place) {
            return;
        }
        if (this.getClaim().hasPermission((OfflinePlayer)event.getPlayer(), Permission.BUILD)) {
            return;
        }
        for (BlockState bs : event.getReplacedBlockStates()) {
            if (!this.check((Cancellable)event, Platform.get().toCenterLocation(bs.getLocation()))) continue;
            this.stdError(event.getPlayer());
            break;
        }
    }

    private void onFluid(@NotNull PlayerInteractEvent event, boolean trueIfPlace) {
        ItemStack is;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player ply = event.getPlayer();
        if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.BUILD)) {
            return;
        }
        EquipmentSlot hnd = Platform.get().getInteractHand(event);
        if (hnd == null) {
            hnd = EquipmentSlot.HAND;
        }
        if ((is = Platform.get().playerInventoryGetItem(ply.getInventory(), hnd)) == null) {
            return;
        }
        if (is.getType().name().toUpperCase(Locale.ROOT).contains("BUCKET")) {
            boolean isBucket = is.getType().equals((Object)Material.BUCKET);
            if (trueIfPlace == isBucket) {
                return;
            }
            Location loc = ply.getLocation();
            Block block = event.getClickedBlock();
            boolean hasWater = false;
            if (block != null) {
                BlockFace face = event.getBlockFace();
                if (PaperLib.isVersion(13)) {
                    BlockData bd = block.getBlockData();
                    if (bd instanceof Waterlogged) {
                        hasWater = ((Waterlogged)bd).isWaterlogged();
                        if (trueIfPlace && hasWater) {
                            Block relBlock = block.getRelative(face);
                            Material type = relBlock.getType();
                            hasWater = type.equals((Object)Material.WATER) || type.equals((Object)Material.LEGACY_WATER) || type.equals((Object)Material.LEGACY_STATIONARY_WATER) || type.equals((Object)Material.LAVA) || type.equals((Object)Material.LEGACY_LAVA) || type.equals((Object)Material.LEGACY_STATIONARY_LAVA);
                            loc = Platform.get().toCenterLocation(relBlock.getLocation());
                        } else {
                            loc = Platform.get().toCenterLocation(block.getLocation());
                        }
                    } else {
                        Block relBlock = block.getRelative(face);
                        Material type = relBlock.getType();
                        hasWater = type.equals((Object)Material.WATER) || type.equals((Object)Material.LEGACY_WATER) || type.equals((Object)Material.LEGACY_STATIONARY_WATER) || type.equals((Object)Material.LAVA) || type.equals((Object)Material.LEGACY_LAVA) || type.equals((Object)Material.LEGACY_STATIONARY_LAVA);
                        loc = Platform.get().toCenterLocation(relBlock.getLocation());
                    }
                }
            }
            if (trueIfPlace == hasWater) {
                return;
            }
            if (this.check((Cancellable)event, loc)) {
                this.stdError(ply);
            }
        }
    }

    @EventHandler
    public void onPlaceFluid(@NotNull PlayerInteractEvent event) {
        if (!this.place) {
            return;
        }
        this.onFluid(event, true);
    }

    @EventHandler
    public void onRemoveFluid(@NotNull PlayerInteractEvent event) {
        if (!this.brk) {
            return;
        }
        this.onFluid(event, false);
    }

    @EventHandler
    public void onBreak(@NotNull BlockBreakEvent event) {
        if (!this.brk) {
            return;
        }
        if (this.getClaim().hasPermission((OfflinePlayer)event.getPlayer(), Permission.BREAK)) {
            return;
        }
        if (this.check((Cancellable)event, Platform.get().toCenterLocation(event.getBlock().getLocation()))) {
            this.stdError(event.getPlayer());
        }
    }

    @EventHandler
    public void onBreak(@NotNull HangingBreakByEntityEvent event) {
        if (!this.brk) {
            return;
        }
        if (!this.getClaim().contains(event.getEntity().getLocation())) {
            return;
        }
        Entity remover = event.getRemover();
        if (remover == null) {
            return;
        }
        if (remover instanceof Player) {
            Player ply = (Player)remover;
            if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.BREAK)) {
                return;
            }
            event.setCancelled(true);
            this.stdError(ply);
        }
    }

    @EventHandler
    public void onDamage(@NotNull BlockDamageEvent event) {
        if (!this.brk) {
            return;
        }
        Player ply = event.getPlayer();
        if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.BREAK)) {
            return;
        }
        if (this.check((Cancellable)event, Platform.get().toCenterLocation(event.getBlock().getLocation()))) {
            this.stdError(ply);
        }
    }

    @EventHandler
    public void onTrample(@NotNull PlayerInteractEvent event) {
        Block block;
        if (!this.brk) {
            return;
        }
        Action action = event.getAction();
        if (action.equals((Object)Action.PHYSICAL) && (block = event.getClickedBlock()) != null) {
            Material type = block.getType();
            if (Arrays.asList(Platform.get().getSoilMaterials()).contains(type)) {
                Player ply = event.getPlayer();
                if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.BREAK)) {
                    return;
                }
                if (this.check((Cancellable)event, Platform.get().toCenterLocation(block.getLocation()))) {
                    this.stdError(ply);
                }
            }
        }
    }

    @EventHandler
    public void onBreakEndCrystal(@NotNull EntityDamageByEntityEvent event) {
        if (!this.brk) {
            return;
        }
        Entity ent = event.getDamager();
        if (ent instanceof Player) {
            Player ply = (Player)ent;
            Entity victim = event.getEntity();
            if (victim instanceof EnderCrystal) {
                if (this.getClaim().hasPermission((OfflinePlayer)ply, Permission.BREAK)) {
                    return;
                }
                if (this.check((Cancellable)event, victim.getLocation())) {
                    this.stdError(ply);
                }
            }
        }
    }

    private boolean check(@NotNull Cancellable cancellable, @NotNull Location location) {
        if (this.getClaim().contains(location)) {
            cancellable.setCancelled(true);
            return true;
        }
        return false;
    }

    public static final class Break
    extends BuildBreakHandler {
        public Break(@NotNull Claim claim) {
            super(claim, false, true);
        }
    }

    public static final class Build
    extends BuildBreakHandler {
        public Build(@NotNull Claim claim) {
            super(claim, true, false);
        }
    }
}

