/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.api.enums;

import codes.wasabi.xclaim.platform.Platform;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Monster;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
abstract class EntityGroupCheck
implements Predicate<EntityType> {
    protected final boolean value;

    @NotNull
    static EntityGroupCheck alive(boolean alive) {
        return new Simple(alive, EntityType::isAlive);
    }

    @NotNull
    static EntityGroupCheck armorStand(boolean armorStand) {
        return new Simple(armorStand, et -> et.equals((Object)EntityType.ARMOR_STAND));
    }

    @NotNull
    static EntityGroupCheck hostile(boolean hostile) {
        return new Hostile(hostile);
    }

    @NotNull
    static EntityGroupCheck vehicle(boolean vehicle) {
        return new Vehicle(vehicle);
    }

    @NotNull
    static EntityGroupCheck misc(boolean misc) {
        EnumSet<EntityType> miscTypes = Platform.get().getMiscTypes();
        return new Simple(misc, miscTypes::contains);
    }

    EntityGroupCheck(boolean value) {
        this.value = value;
    }

    private static class Simple
    extends EntityGroupCheck {
        private final Predicate<EntityType> positive;

        Simple(boolean value, @NotNull Predicate<EntityType> positive) {
            super(value);
            this.positive = positive;
        }

        @Override
        public boolean test(EntityType entityType) {
            return this.positive.test(entityType) == this.value;
        }
    }

    private static class Hostile
    extends WithClass {
        private static final Class<? extends Entity> ENEMY_CLASS;
        private static final boolean ENEMY_CLASS_EXISTS;
        private static final String[] LEGACY_EXCEPTIONS;

        Hostile(boolean value) {
            super(value);
        }

        @Override
        protected boolean testClass(@NotNull Class<? extends Entity> clazz) {
            if (ENEMY_CLASS_EXISTS) {
                return ENEMY_CLASS.isAssignableFrom(clazz);
            }
            boolean ret = Monster.class.isAssignableFrom(clazz);
            if (!ret) {
                String className = clazz.getName();
                for (String monster : LEGACY_EXCEPTIONS) {
                    if (!monster.equals(className)) continue;
                    ret = true;
                    break;
                }
            }
            return ret;
        }

        static {
            Class<Entity> clazz = null;
            boolean classExists = false;
            String[] exceptions = null;
            try {
                clazz = Class.forName("org.bukkit.entity.Enemy").asSubclass(Entity.class);
                classExists = true;
            }
            catch (ClassCastException | ClassNotFoundException exception) {
                // empty catch block
            }
            if (!classExists) {
                exceptions = new String[]{"org.bukkit.entity.EnderDragon", "org.bukkit.entity.Ghast", "org.bukkit.entity.MagmaCube", "org.bukkit.entity.Phantom", "org.bukkit.entity.Shulker", "org.bukkit.entity.Slime"};
            }
            ENEMY_CLASS = clazz;
            ENEMY_CLASS_EXISTS = classExists;
            LEGACY_EXCEPTIONS = exceptions;
        }
    }

    private static class Vehicle
    extends WithClass {
        Vehicle(boolean value) {
            super(value);
        }

        @Override
        protected boolean testClass(@NotNull Class<? extends Entity> clazz) {
            return org.bukkit.entity.Vehicle.class.isAssignableFrom(clazz);
        }
    }

    private static abstract class WithClass
    extends EntityGroupCheck {
        WithClass(boolean value) {
            super(value);
        }

        @Override
        public boolean test(@NotNull EntityType entityType) {
            Class clazz = entityType.getEntityClass();
            if (clazz == null) {
                return false;
            }
            return this.testClass(clazz) == this.value;
        }

        protected abstract boolean testClass(@NotNull Class<? extends Entity> var1);
    }
}

