/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.api.enums;

import codes.wasabi.xclaim.api.enums.EntityGroupCheck;
import codes.wasabi.xclaim.debug.Debuggable;
import codes.wasabi.xclaim.debug.goal.DebugGoal;
import codes.wasabi.xclaim.debug.writer.DebugWriter;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

@Debuggable
public enum EntityGroup {
    FRIENDLY(EntityGroupCheck.alive(true), EntityGroupCheck.armorStand(false), EntityGroupCheck.hostile(false)),
    HOSTILE(EntityGroupCheck.alive(true), EntityGroupCheck.armorStand(false), EntityGroupCheck.hostile(true)),
    VEHICLE(EntityGroupCheck.alive(false), EntityGroupCheck.vehicle(true)),
    NOT_ALIVE(true, EntityGroupCheck.armorStand(true), EntityGroupCheck.alive(false), EntityGroupCheck.misc(false), EntityGroupCheck.vehicle(false)),
    MISC(EntityGroupCheck.misc(true), new EntityGroupCheck[0]);

    private final Predicate<EntityType> predicate;
    private EnumSet<EntityType> set = null;

    private EntityGroup(boolean or, EntityGroupCheck a, EntityGroupCheck ... b) {
        Predicate<EntityType> predicate = a;
        if (b.length != 0) {
            Predicate<EntityType> extra = b[0];
            for (int i = 1; i < b.length; ++i) {
                extra = extra.and(b[i]);
            }
            predicate = or ? predicate.or(extra) : predicate.and(extra);
        }
        this.predicate = predicate;
    }

    private EntityGroup(EntityGroupCheck a, EntityGroupCheck ... b) {
        this(false, a, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private EnumSet<EntityType> getSet0() {
        EntityGroup entityGroup = this;
        synchronized (entityGroup) {
            if (this.set != null) {
                return this.set;
            }
            EnumSet<EntityType> set = EnumSet.noneOf(EntityType.class);
            for (EntityType type : EntityType.values()) {
                if (!this.predicate.test(type)) continue;
                set.add(type);
            }
            this.set = set;
            return this.set;
        }
    }

    @NotNull
    public @UnmodifiableView Set<EntityType> getSet() {
        return Collections.unmodifiableSet(this.getSet0());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(value=" -> new")
    @NotNull
    public EnumSet<EntityType> getList() {
        return this.getSet0();
    }

    public boolean contains(@NotNull EntityType type) {
        return this.predicate.test(type);
    }

    public boolean contains(@NotNull Entity entity) {
        return this.predicate.test(entity.getType());
    }

    @DebugGoal(async=true)
    @ApiStatus.Internal
    public static void debug(@NotNull DebugWriter out) {
        for (EntityGroup eg : EntityGroup.values()) {
            out.color(NamedTextColor.GOLD);
            out.println("= " + eg.name() + " =");
            out.color(NamedTextColor.WHITE);
            for (EntityType et : eg.getSet()) {
                out.println("- " + et.name());
            }
            out.println();
        }
    }
}

