/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.api;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.util.ProxyList;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XCPlayer {
    private static final ReentrantReadWriteLock trustConfigLock = new ReentrantReadWriteLock();
    private final UUID uuid;
    private final StampedLock valuesLock = new StampedLock();
    private int valuesFlag = 0;
    private OfflinePlayer op;
    private String uuidString;

    @NotNull
    public static XCPlayer of(@NotNull OfflinePlayer ply) {
        return new XCPlayer(ply);
    }

    @NotNull
    public static XCPlayer of(@NotNull UUID uuid) {
        return new XCPlayer(uuid);
    }

    protected XCPlayer(@NotNull UUID uuid) {
        this.uuid = uuid;
    }

    protected XCPlayer(@NotNull OfflinePlayer ply) {
        this(ply.getUniqueId());
        this.valuesFlag = 1;
        this.op = ply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public OfflinePlayer getOfflinePlayer() {
        long stamp = this.valuesLock.readLock();
        try {
            if ((this.valuesFlag & 1) == 1) {
                OfflinePlayer offlinePlayer = this.op;
                return offlinePlayer;
            }
            stamp = this.valuesLock.tryConvertToWriteLock(stamp);
            this.op = Bukkit.getOfflinePlayer((UUID)this.uuid);
            this.valuesFlag |= 1;
            OfflinePlayer offlinePlayer = this.op;
            return offlinePlayer;
        }
        finally {
            this.valuesLock.unlock(stamp);
        }
    }

    @Nullable
    public Player getPlayer() {
        return this.getOfflinePlayer().getPlayer();
    }

    public boolean trustPlayer(@NotNull OfflinePlayer player) {
        return this.getTrustedPlayersSet().add(player);
    }

    public boolean untrustPlayer(@NotNull OfflinePlayer player) {
        return this.getTrustedPlayersSet().remove(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playerTrusted(@NotNull OfflinePlayer player) {
        List entries;
        String query = player.getUniqueId().toString();
        trustConfigLock.readLock().lock();
        try {
            entries = XClaim.trustConfig.getList(this.getUUIDString(), new ArrayList());
        }
        finally {
            trustConfigLock.readLock().unlock();
        }
        for (Object ob : entries) {
            if (!(ob instanceof String) || !Objects.equals(ob, query)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public int getNumTrustedPlayers() {
        List entries;
        trustConfigLock.readLock().lock();
        try {
            entries = XClaim.trustConfig.getList(this.getUUIDString(), new ArrayList());
        }
        finally {
            trustConfigLock.readLock().unlock();
        }
        return entries.size();
    }

    @NotNull
    private LinkedHashSet<UUID> getCurrentTrustedPlayers() {
        List entries;
        trustConfigLock.readLock().lock();
        try {
            entries = XClaim.trustConfig.getList(this.getUUIDString(), new ArrayList());
        }
        finally {
            trustConfigLock.readLock().unlock();
        }
        LinkedHashSet<UUID> set = new LinkedHashSet<UUID>();
        for (Object ob : entries) {
            if (!(ob instanceof String)) continue;
            try {
                UUID uuid = UUID.fromString((String)ob);
                set.add(uuid);
            }
            catch (Exception exception) {}
        }
        return set;
    }

    public void setTrustedPlayers(@NotNull List<OfflinePlayer> players) {
        ProxyList<OfflinePlayer, UUID> uuidList = new ProxyList<OfflinePlayer, UUID>(players, OfflinePlayer::getUniqueId);
        this.setTrustedPlayers0(uuidList);
    }

    private void setTrustedPlayers0(@NotNull List<UUID> players) {
        ProxyList<UUID, String> strList = new ProxyList<UUID, String>(players, UUID::toString);
        trustConfigLock.writeLock().lock();
        try {
            XClaim.trustConfig.set(this.getUUIDString(), strList);
        }
        finally {
            trustConfigLock.writeLock().unlock();
        }
    }

    public int getMaxChunks() {
        return this.negativeAsInf(XClaim.mainConfig.rules().maxChunks((Permissible)this.getPlayer()));
    }

    public int getMaxClaims() {
        return this.negativeAsInf(XClaim.mainConfig.rules().maxClaims((Permissible)this.getPlayer()));
    }

    public double getClaimPrice() {
        return XClaim.mainConfig.integrations().economy().claimPrice((Permissible)this.getPlayer()).intValue();
    }

    public double getUnclaimReward() {
        return XClaim.mainConfig.integrations().economy().unclaimReward((Permissible)this.getPlayer()).intValue();
    }

    public int getFreeChunks() {
        return this.negativeAsInf(XClaim.mainConfig.integrations().economy().freeChunks((Permissible)this.getPlayer()));
    }

    public int getMaxClaimsInWorld() {
        return this.negativeAsInf(XClaim.mainConfig.rules().maxClaimsInWorld((Permissible)this.getPlayer()));
    }

    private int negativeAsInf(int value) {
        if (value < 0) {
            return Integer.MAX_VALUE;
        }
        return value;
    }

    @NotNull
    public List<OfflinePlayer> getTrustedPlayers() {
        final LinkedHashSet<UUID> current = this.getCurrentTrustedPlayers();
        return new AbstractList<OfflinePlayer>(){

            private UUID get0(int i) {
                int size = current.size();
                if (i < 0 || i >= size) {
                    throw new IllegalArgumentException("Index " + i + " out of bounds for length " + size);
                }
                for (UUID next : current) {
                    if (i-- != 0) continue;
                    return next;
                }
                throw new ConcurrentModificationException();
            }

            @Override
            public OfflinePlayer get(int i) {
                return Bukkit.getOfflinePlayer((UUID)this.get0(i));
            }

            @Override
            public int size() {
                return current.size();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof OfflinePlayer)) {
                    return false;
                }
                UUID id = ((OfflinePlayer)o).getUniqueId();
                return current.contains(id);
            }

            @Override
            public boolean add(OfflinePlayer offlinePlayer) {
                current.add(offlinePlayer.getUniqueId());
                XCPlayer.this.setTrustedPlayers0(new ArrayList(current));
                return true;
            }

            @Override
            public void add(int index, OfflinePlayer element) {
                int i;
                int size = current.size();
                if (index < 0 || index > size) {
                    throw new IllegalArgumentException("Index " + index + " out of bounds for length " + size);
                }
                if (index == size) {
                    this.add(element);
                    return;
                }
                UUID id = element.getUniqueId();
                if (current.contains(id)) {
                    return;
                }
                ArrayList<UUID> newList = new ArrayList<UUID>(size + 1);
                for (i = 0; i < index; ++i) {
                    newList.add(this.get0(i));
                }
                newList.add(id);
                for (i = index; i < size; ++i) {
                    newList.add(this.get0(i));
                }
                XCPlayer.this.setTrustedPlayers0(newList);
                current.clear();
                current.addAll(newList);
            }

            @Override
            public OfflinePlayer set(int index, OfflinePlayer element) {
                int i;
                int size = current.size();
                if (index < 0 || index >= size) {
                    throw new IllegalArgumentException("Index " + index + " out of bounds for length " + size);
                }
                UUID oldValue = this.get0(index);
                UUID id = element.getUniqueId();
                if (current.contains(id)) {
                    if (oldValue.equals(id)) {
                        return element;
                    }
                    return this.remove(index);
                }
                ArrayList<UUID> newList = new ArrayList<UUID>(size);
                for (i = 0; i < index; ++i) {
                    newList.add(this.get0(i));
                }
                newList.add(id);
                for (i = index + 1; i < size; ++i) {
                    newList.add(this.get0(i));
                }
                XCPlayer.this.setTrustedPlayers0(newList);
                current.clear();
                current.addAll(newList);
                return Bukkit.getOfflinePlayer((UUID)oldValue);
            }

            @Override
            public OfflinePlayer remove(int index) {
                UUID id = this.get0(index);
                if (current.remove(id)) {
                    XCPlayer.this.setTrustedPlayers0(new ArrayList(current));
                }
                return Bukkit.getOfflinePlayer((UUID)id);
            }

            @Override
            @NotNull
            public Iterator<OfflinePlayer> iterator() {
                return current.stream().map(Bukkit::getOfflinePlayer).iterator();
            }
        };
    }

    @NotNull
    public Set<OfflinePlayer> getTrustedPlayersSet() {
        final LinkedHashSet<UUID> current = this.getCurrentTrustedPlayers();
        return new AbstractSet<OfflinePlayer>(){

            @Override
            @NotNull
            public Iterator<OfflinePlayer> iterator() {
                return Collections.unmodifiableSet(current).stream().map(Bukkit::getOfflinePlayer).iterator();
            }

            @Override
            public int size() {
                return current.size();
            }

            @Override
            public boolean isEmpty() {
                return current.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof OfflinePlayer)) {
                    return false;
                }
                UUID id = ((OfflinePlayer)o).getUniqueId();
                return current.contains(id);
            }

            @Override
            public boolean add(OfflinePlayer offlinePlayer) {
                UUID id = offlinePlayer.getUniqueId();
                if (current.add(id)) {
                    XCPlayer.this.setTrustedPlayers0(new ArrayList(current));
                    return true;
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof OfflinePlayer)) {
                    return false;
                }
                UUID id = ((OfflinePlayer)o).getUniqueId();
                if (current.remove(id)) {
                    XCPlayer.this.setTrustedPlayers0(new ArrayList(current));
                    return true;
                }
                return false;
            }

            @Override
            public void clear() {
                current.clear();
                XCPlayer.this.setTrustedPlayers(Collections.emptyList());
            }

            @Override
            public boolean addAll(@NotNull Collection<? extends OfflinePlayer> c) {
                boolean any = false;
                for (OfflinePlayer offlinePlayer : c) {
                    UUID id = offlinePlayer.getUniqueId();
                    if (!current.add(id)) continue;
                    any = true;
                }
                if (any) {
                    XCPlayer.this.setTrustedPlayers0(new ArrayList(current));
                }
                return any;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean any = false;
                for (Object ob : c) {
                    UUID id;
                    if (!(ob instanceof OfflinePlayer) || !current.add(id = ((OfflinePlayer)ob).getUniqueId())) continue;
                    any = true;
                }
                if (any) {
                    XCPlayer.this.setTrustedPlayers0(new ArrayList(current));
                }
                return any;
            }
        };
    }

    public int hashCode() {
        return Objects.hashCode(this.uuid);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof XCPlayer) {
            return ((XCPlayer)obj).uuid.equals(this.uuid);
        }
        return super.equals(obj);
    }

    public String toString() {
        return "XCPlayer[uuid=" + this.uuid + "]";
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getUUIDString() {
        long stamp = this.valuesLock.readLock();
        try {
            if ((this.valuesFlag & 2) == 2) {
                String string = this.uuidString;
                return string;
            }
            stamp = this.valuesLock.tryConvertToWriteLock(stamp);
            this.uuidString = this.uuid.toString();
            this.valuesFlag |= 2;
            String string = this.uuidString;
            return string;
        }
        finally {
            this.valuesLock.unlock(stamp);
        }
    }

    @Nullable
    public String getName() {
        return this.getOfflinePlayer().getName();
    }
}

