/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.api;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.platform.PlatformSchedulerTask;
import codes.wasabi.xclaim.shadow.kyori.adventure.platform.bukkit.BukkitAudiences;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class GraceRoutine
implements Listener {
    private static GraceRoutine instance = null;
    private static boolean active = false;
    private final PlatformSchedulerTask timerTask;
    private final long graceTimeMillis;
    private final BukkitAudiences adv = Platform.getAdventure();

    public static void start() {
        if (!active) {
            instance = new GraceRoutine();
            Bukkit.getPluginManager().registerEvents((Listener)instance, (Plugin)XClaim.instance);
            active = true;
        }
    }

    public static void stop() {
        if (active) {
            HandlerList.unregisterAll((Listener)instance);
            GraceRoutine.instance.timerTask.cancel();
            instance = null;
            active = false;
        }
    }

    public static void refresh() {
        HashMap<World, Boolean> allowedMap = new HashMap<World, Boolean>();
        for (Claim claim : Claim.getAll()) {
            World world = claim.getWorld();
            if (world == null) continue;
            Boolean allowed = (Boolean)allowedMap.get(world);
            if (allowed == null) {
                allowed = XClaim.mainConfig.worlds().checkLists(world);
                allowedMap.put(world, allowed);
            }
            if (allowed.booleanValue()) continue;
            GraceRoutine.start();
            return;
        }
        GraceRoutine.stop();
    }

    private GraceRoutine() {
        long graceTime = Math.max(XClaim.mainConfig.worlds().graceTime(), 0L);
        this.graceTimeMillis = graceTime * 1000L;
        long ticks = Math.max((long)Math.floor((double)graceTime / 4.0 * 20.0), 1L);
        ticks = Math.min(ticks, 200L);
        this.timerTask = Platform.get().getScheduler().runTaskTimerAsynchronously((Plugin)XClaim.instance, this::evaluate, 0L, ticks);
    }

    private void evaluate() {
        long now = System.currentTimeMillis();
        int count = 0;
        HashMap<World, Boolean> allowedMap = new HashMap<World, Boolean>();
        for (Claim c : Claim.getAll()) {
            long elapsed;
            World world = c.getWorld();
            if (world == null) continue;
            Boolean allowed = (Boolean)allowedMap.get(world);
            if (allowed == null) {
                allowed = XClaim.mainConfig.worlds().checkLists(world);
                allowedMap.put(world, allowed);
            }
            if (allowed.booleanValue()) continue;
            ++count;
            long start = c.getGraceStart();
            if (start <= 0L) {
                start = now;
                c.setGraceStart(start);
            }
            if ((elapsed = now - start) < this.graceTimeMillis) continue;
            OfflinePlayer op = c.getOwner().getOfflinePlayer();
            c.unclaim();
            Player ply = op.getPlayer();
            if (ply != null) {
                this.adv.player(ply).sendMessage(XClaim.lang.getComponent("grace-remove", c.getName()));
            }
            --count;
        }
        if (count < 1) {
            GraceRoutine.stop();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent event) {
        Player ply = event.getPlayer();
        int count = 0;
        for (Claim c : Claim.getByOwner((OfflinePlayer)ply)) {
            World world = c.getWorld();
            if (world == null || XClaim.mainConfig.worlds().checkLists(world)) continue;
            ++count;
        }
        if (count < 1) {
            return;
        }
        Platform.getAdventure().player(ply).sendMessage(XClaim.lang.getComponent("grace-alert", count));
    }
}

