/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.api;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.XCPlayer;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.api.enums.TrustLevel;
import codes.wasabi.xclaim.api.enums.permission.PermissionHandler;
import codes.wasabi.xclaim.gui.ChunkEditor;
import codes.wasabi.xclaim.map.MapService;
import codes.wasabi.xclaim.map.MapServiceOp;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.platform.PlatformPersistentDataContainer;
import codes.wasabi.xclaim.platform.PlatformPersistentDataType;
import codes.wasabi.xclaim.util.BoundingBox;
import codes.wasabi.xclaim.util.ChunkReference;
import codes.wasabi.xclaim.util.StringUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class Claim {
    private static final Set<RegistryEntry> registry = new HashSet<RegistryEntry>();
    private static final ReentrantReadWriteLock registryLock = new ReentrantReadWriteLock();
    private String name;
    private final Set<ChunkReference> chunks;
    private XCPlayer owner;
    private final Map<Permission, TrustLevel> globalPerms;
    private final Map<UUID, EnumSet<Permission>> playerPerms;
    private final List<Consumer<Claim>> ownerChangeCallbacks = Collections.synchronizedList(new ArrayList());
    private BoundingBox outerBounds;
    private boolean manageHandlers = false;
    private long graceStart = -1L;
    private final Map<Permission, PermissionHandler> handlers = new HashMap<Permission, PermissionHandler>();

    @NotNull
    public static @UnmodifiableView Set<Claim> getAll() {
        HashSet<Claim> ret;
        registryLock.readLock().lock();
        try {
            ret = new HashSet<Claim>(registry.size());
            for (RegistryEntry entry : registry) {
                ret.add(entry.claim());
            }
        }
        finally {
            registryLock.readLock().unlock();
        }
        return Collections.unmodifiableSet(ret);
    }

    public static boolean exists(@NotNull CharSequence name) {
        registryLock.readLock().lock();
        try {
            boolean bl = registry.contains(RegistryEntry.fake(name));
            return bl;
        }
        finally {
            registryLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Claim getByName(@NotNull String name, boolean ignoreCase) {
        registryLock.readLock().lock();
        try {
            if (!registry.contains(RegistryEntry.fake(name))) {
                Claim claim = null;
                return claim;
            }
            for (RegistryEntry re : registry) {
                if (!re.claimNameEquals(name, ignoreCase)) continue;
                Claim claim = re.claim();
                return claim;
            }
            Iterator<RegistryEntry> iterator = null;
            return iterator;
        }
        finally {
            registryLock.readLock().unlock();
        }
    }

    @Nullable
    public static Claim getByName(@NotNull String name) {
        return Claim.getByName(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static @UnmodifiableView Set<Claim> getByOwner(@NotNull XCPlayer owner) {
        registryLock.readLock().lock();
        try {
            HashSet<Claim> set = new HashSet<Claim>();
            for (RegistryEntry re : registry) {
                if (!re.claim().owner.getUniqueId().equals(owner.getUniqueId())) continue;
                set.add(re.claim());
            }
            Set set2 = Collections.unmodifiableSet(set);
            return set2;
        }
        finally {
            registryLock.readLock().unlock();
        }
    }

    @NotNull
    public static @UnmodifiableView Set<Claim> getByOwner(@NotNull OfflinePlayer owner) {
        return Claim.getByOwner(XCPlayer.of(owner));
    }

    @Nullable
    public static Claim getByChunk(@NotNull Chunk chunk) {
        return Claim.getByChunk(ChunkReference.ofChunk(chunk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Claim getByChunk(@NotNull ChunkReference cr) {
        registryLock.readLock().lock();
        try {
            for (RegistryEntry re : registry) {
                for (ChunkReference chk : re.claim().chunks) {
                    if (!chk.matches(cr)) continue;
                    Claim claim = re.claim();
                    return claim;
                }
            }
            Iterator<RegistryEntry> iterator = null;
            return iterator;
        }
        finally {
            registryLock.readLock().unlock();
        }
    }

    @NotNull
    public static Claim deserialize(@NotNull ConfigurationSection section) throws IllegalArgumentException {
        UUID ownerUUID;
        String name = section.getString("name");
        if (name == null) {
            throw new IllegalArgumentException("Missing property \"name\"");
        }
        String ownerUUIDString = section.getString("owner");
        if (ownerUUIDString == null) {
            throw new IllegalArgumentException("Missing property \"owner\"");
        }
        try {
            ownerUUID = UUID.fromString(ownerUUIDString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Property \"owner\" is not a valid UUID");
        }
        OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)ownerUUID);
        String worldName = section.getString("world");
        if (worldName == null) {
            throw new IllegalArgumentException("Missing property \"world\"");
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            throw new IllegalArgumentException("No world with the name \"" + worldName + "\" could be found");
        }
        HashSet<ChunkReference> chunks = new HashSet<ChunkReference>();
        ConfigurationSection sec = section.getConfigurationSection("chunks");
        if (sec == null) {
            throw new IllegalArgumentException("Missing property \"chunks\"");
        }
        for (Object key : sec.getKeys(false)) {
            ConfigurationSection sc = sec.getConfigurationSection((String)key);
            if (sc == null) {
                throw new IllegalArgumentException("Chunk with ID " + (String)key + " is malformed!");
            }
            int x = sc.getInt("x");
            int z = sc.getInt("z");
            chunks.add(new ChunkReference(world, x, z));
        }
        HashMap<Permission, TrustLevel> global = new HashMap<Permission, TrustLevel>();
        sec = section.getConfigurationSection("permissions");
        if (sec == null) {
            throw new IllegalArgumentException("Missing property \"permissions\"");
        }
        for (Object key : sec.getKeys(false)) {
            TrustLevel trust;
            Permission perm;
            try {
                perm = Permission.fromName((String)key);
                if (perm == null) {
                    continue;
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unknown permission \"" + (String)key + "\"");
            }
            String value = sec.getString((String)key);
            if (value == null) {
                throw new IllegalArgumentException("Illegal value for permissions." + (String)key);
            }
            try {
                trust = TrustLevel.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unknown trust level \"" + (String)key + "\"");
            }
            global.put(perm, trust);
        }
        HashMap<UUID, EnumSet<Permission>> players = new HashMap<UUID, EnumSet<Permission>>();
        sec = section.getConfigurationSection("users");
        if (sec == null) {
            throw new IllegalArgumentException("Missing property \"users\"");
        }
        for (String key : sec.getKeys(false)) {
            UUID uuid;
            try {
                uuid = UUID.fromString(key);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("\"" + key + "\" is not a valid UUID");
            }
            EnumSet<Permission> set = EnumSet.noneOf(Permission.class);
            List list = sec.getList(key);
            if (list == null) {
                throw new IllegalArgumentException("users." + key + " is not a list");
            }
            for (int i = 0; i < list.size(); ++i) {
                Object ob = list.get(i);
                if (ob instanceof String) {
                    Permission perm;
                    String str = (String)ob;
                    try {
                        perm = Permission.fromName(str);
                        if (perm == null) {
                            continue;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Unknown permission \"" + str + "\"");
                    }
                    set.add(perm);
                    continue;
                }
                throw new IllegalArgumentException("Element " + i + " of users." + key + " is not a string");
            }
            players.put(uuid, set);
        }
        Claim ret = new Claim(name, chunks, XCPlayer.of(owner), global, players, -1);
        if (section.contains("graceStart")) {
            ret.graceStart = section.getLong("graceStart", -1L);
        }
        return ret;
    }

    private void validateMarkers() {
        if (MapService.isAvailable()) {
            MapService ms = MapService.getNonNull();
            ms.queueOperation(MapServiceOp.update(this));
        }
    }

    private void generateBounds() {
        BoundingBox bb = null;
        boolean set = false;
        for (ChunkReference c : this.chunks) {
            BoundingBox bounds = c.getBounds();
            if (!set) {
                bb = bounds;
                set = true;
                continue;
            }
            bb.union(bounds);
        }
        this.outerBounds = set ? bb : new BoundingBox();
        this.validateMarkers();
    }

    @NotNull
    public BoundingBox getOuterBounds() {
        return this.outerBounds;
    }

    Claim(@NotNull String name, @NotNull Set<ChunkReference> chunks, @NotNull XCPlayer owner, @NotNull Map<Permission, TrustLevel> globalPerms, @NotNull Map<UUID, EnumSet<Permission>> playerPerms, int dummy) {
        this.name = name;
        this.chunks = Collections.synchronizedSet(new HashSet<ChunkReference>(chunks));
        this.owner = owner;
        this.globalPerms = Collections.synchronizedMap(new HashMap<Permission, TrustLevel>(globalPerms));
        this.playerPerms = Collections.synchronizedMap(new HashMap<UUID, EnumSet<Permission>>(playerPerms));
        this.nameRepeatCheck();
        this.generateBounds();
    }

    Claim(@NotNull String name, @NotNull Set<Chunk> chunks, @NotNull XCPlayer owner, @NotNull Map<Permission, TrustLevel> globalPerms, @NotNull Map<UUID, EnumSet<Permission>> playerPerms) {
        this(name, chunks.stream().map(ChunkReference::ofChunk).collect(Collectors.toSet()), owner, globalPerms, playerPerms, -1);
    }

    public Claim(@NotNull String name, @NotNull Set<Chunk> chunks, @NotNull XCPlayer owner) {
        this(name, chunks, owner, Collections.emptyMap(), Collections.emptyMap());
    }

    public Claim(@NotNull String name, @NotNull Set<Chunk> chunks, @NotNull OfflinePlayer owner) {
        this(name, chunks, XCPlayer.of(owner), Collections.emptyMap(), Collections.emptyMap());
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        for (Player ply : Bukkit.getOnlinePlayers()) {
            if (!Objects.equals(ChunkEditor.getEditing(ply), this)) continue;
            PlatformPersistentDataContainer pdc = Platform.get().getPersistentDataContainer((Entity)ply);
            pdc.set(ChunkEditor.getNameKey(), PlatformPersistentDataType.STRING, name);
        }
        this.name = name;
        this.nameRepeatCheck();
    }

    public XCPlayer getOwner() {
        return this.owner;
    }

    public void setOwner(@NotNull OfflinePlayer op) {
        this.owner = XCPlayer.of(op);
        this.nameRepeatCheck();
        this.ownerChangeCallbacks.forEach(consumer -> consumer.accept(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nameRepeatCheck() {
        if (this.owner == null) {
            return;
        }
        String desiredName = this.name;
        String targetName = this.name;
        int i = 0;
        UUID ownerId = this.owner.getUniqueId();
        registryLock.readLock().lock();
        try {
            boolean ok;
            block3: do {
                if (!registry.contains(RegistryEntry.fake(targetName))) {
                    break;
                }
                ok = true;
                for (RegistryEntry re : registry) {
                    Claim c = re.claim();
                    if (c == this || c.owner == null || c.owner.getUniqueId() != ownerId || !c.name.equalsIgnoreCase(targetName)) continue;
                    targetName = desiredName + " (" + ++i + ")";
                    ok = false;
                    continue block3;
                }
            } while (!ok);
        }
        finally {
            registryLock.readLock().unlock();
        }
        this.name = targetName;
    }

    @NotNull
    public String getUniqueToken() {
        byte[] digest;
        byte[] nameBytes = this.name.getBytes(StandardCharsets.UTF_8);
        UUID uuid = this.owner.getUniqueId();
        ByteBuffer digestBuffer = ByteBuffer.allocate(nameBytes.length + 16);
        digestBuffer.put(nameBytes);
        digestBuffer.putLong(uuid.getMostSignificantBits());
        digestBuffer.putLong(uuid.getLeastSignificantBits());
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            digest = md.digest(digestBuffer.array());
        }
        catch (NoSuchAlgorithmException e) {
            digest = digestBuffer.array();
        }
        return StringUtil.bytesToHex(digest);
    }

    public void onOwnerChanged(@NotNull Consumer<Claim> callback) {
        this.ownerChangeCallbacks.add(callback);
    }

    @NotNull
    public @UnmodifiableView Set<ChunkReference> getChunks() {
        return Collections.unmodifiableSet(this.chunks);
    }

    @Nullable
    public World getWorld() {
        if (this.chunks.size() > 0) {
            return this.chunks.iterator().next().world;
        }
        return null;
    }

    public long getGraceStart() {
        return this.graceStart;
    }

    public void setGraceStart(long graceStart) {
        this.graceStart = graceStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChunk(@NotNull Chunk chunk) throws IllegalArgumentException {
        boolean claim = false;
        if (this.chunks.size() > 0) {
            World w = this.chunks.iterator().next().world;
            if (w != chunk.getWorld()) {
                throw new IllegalArgumentException("New chunks must be in the same world as previous chunks!");
            }
        } else {
            claim = true;
        }
        boolean ret = true;
        for (ChunkReference other : this.chunks) {
            if (!other.matches(chunk)) continue;
            ret = false;
            break;
        }
        ChunkReference ref = ChunkReference.ofChunk(chunk);
        if (ret) {
            ret = this.chunks.add(ref);
        }
        if (ret) {
            this.generateBounds();
            if (this.manageHandlers) {
                ArrayList<Claim> collides = new ArrayList<Claim>(1);
                registryLock.readLock().lock();
                try {
                    for (RegistryEntry re : registry) {
                        Claim c = re.claim();
                        if (c == this || !c.chunks.contains(ref)) continue;
                        collides.add(c);
                    }
                }
                finally {
                    registryLock.readLock().unlock();
                }
                for (Claim collided : collides) {
                    collided.removeChunk(ref);
                }
            } else if (claim) {
                this.claim();
            }
        }
        return ret;
    }

    public boolean removeChunk(@NotNull Chunk chunk) {
        return this.removeChunk(ChunkReference.ofChunk(chunk));
    }

    public boolean removeChunk(@NotNull ChunkReference ref) {
        boolean ret = this.chunks.remove(ref);
        if (!ret) {
            HashSet<ChunkReference> toRemove = new HashSet<ChunkReference>();
            for (ChunkReference chk : this.chunks) {
                if (!chk.equals(ref)) continue;
                toRemove.add(chk);
            }
            ret = this.chunks.removeAll(toRemove);
        }
        if (ret) {
            this.generateBounds();
            if (this.manageHandlers && this.chunks.size() < 1) {
                this.unclaim();
            }
        }
        return ret;
    }

    public boolean contains(@NotNull Location location) {
        Vector vector = location.toVector();
        if (!this.outerBounds.contains(vector)) {
            return false;
        }
        boolean first = true;
        for (ChunkReference c : this.getChunks()) {
            if (first && c.world != location.getWorld()) {
                return false;
            }
            first = false;
            if (!c.getBounds().contains(vector)) continue;
            return true;
        }
        return false;
    }

    public boolean containsChunk(@NotNull ChunkReference cr) {
        return this.chunks.contains(cr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long minSquareDistance(@NotNull ChunkReference cr) {
        if (this.chunks.contains(cr)) {
            return 0L;
        }
        long ret = Long.MAX_VALUE;
        Set<ChunkReference> set = this.chunks;
        synchronized (set) {
            for (ChunkReference mcr : this.chunks) {
                if (!mcr.world.getUID().equals(cr.world.getUID())) continue;
                long tmp = mcr.x - cr.x;
                long dist = tmp * tmp;
                tmp = mcr.z - cr.z;
                if ((dist += tmp * tmp) >= ret) continue;
                ret = dist;
                if (dist != 0L) continue;
                break;
            }
        }
        return ret;
    }

    public void setPermission(@NotNull Permission permission, @NotNull TrustLevel trustLevel) {
        this.globalPerms.put(permission, trustLevel);
        this.updateHandlers();
    }

    @NotNull
    public TrustLevel getPermission(@NotNull Permission permission) {
        return this.globalPerms.getOrDefault((Object)permission, permission.getDefaultTrust());
    }

    @NotNull
    public @UnmodifiableView Map<Permission, TrustLevel> getPermissions() {
        HashMap<Permission, TrustLevel> ret = new HashMap<Permission, TrustLevel>();
        for (Permission p : Permission.values()) {
            ret.put(p, this.globalPerms.getOrDefault((Object)p, p.getDefaultTrust()));
        }
        return Collections.unmodifiableMap(ret);
    }

    public void setUserPermission(@NotNull OfflinePlayer player, @NotNull Permission permission, boolean value) {
        UUID uuid = player.getUniqueId();
        EnumSet<Permission> set = this.playerPerms.get(uuid);
        if (set == null) {
            set = EnumSet.noneOf(Permission.class);
        }
        if (value) {
            set.add(permission);
            this.playerPerms.put(uuid, set);
        } else {
            set.remove((Object)permission);
            if (set.size() > 0) {
                this.playerPerms.put(uuid, set);
            } else {
                this.playerPerms.remove(uuid);
            }
        }
        this.updateHandlers();
    }

    public boolean getUserPermission(@NotNull OfflinePlayer player, @NotNull Permission permission) {
        UUID uuid = player.getUniqueId();
        EnumSet<Permission> set = this.playerPerms.get(uuid);
        if (set == null) {
            return false;
        }
        return set.contains((Object)permission);
    }

    @NotNull
    public @UnmodifiableView Map<XCPlayer, EnumSet<Permission>> getUserPermissions() {
        HashMap<XCPlayer, EnumSet<Permission>> ret = new HashMap<XCPlayer, EnumSet<Permission>>();
        for (UUID uuid : this.playerPerms.keySet()) {
            OfflinePlayer ply = Bukkit.getOfflinePlayer((UUID)uuid);
            ret.put(XCPlayer.of(ply), this.playerPerms.get(uuid));
        }
        return Collections.unmodifiableMap(ret);
    }

    public void clearUserPermissions(@NotNull OfflinePlayer player) {
        this.playerPerms.remove(player.getUniqueId());
    }

    public boolean hasPermission(@NotNull OfflinePlayer player, @NotNull Permission permission) {
        if (XClaim.mainConfig.rules().exemptOwner().booleanValue() && player.getUniqueId().equals(this.owner.getUniqueId())) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        Player online = player.getPlayer();
        if (online != null && online.hasPermission("xclaim.admin")) {
            return true;
        }
        EnumSet<Permission> set = this.playerPerms.get(player.getUniqueId());
        if (set != null && set.contains((Object)permission)) {
            return true;
        }
        TrustLevel tl = this.globalPerms.getOrDefault((Object)permission, permission.getDefaultTrust());
        switch (tl) {
            case VETERANS: {
                long required;
                long firstLogin = player.getFirstPlayed();
                if (firstLogin == 0L) {
                    return false;
                }
                long duration = (long)Math.floor((double)(System.currentTimeMillis() - firstLogin) / 1000.0);
                return duration >= (required = XClaim.mainConfig.veteranTime().longValue());
            }
            case TRUSTED: {
                return this.owner.playerTrusted(player);
            }
            case ALL: {
                return true;
            }
        }
        return false;
    }

    public void serialize(@NotNull ConfigurationSection section) {
        section.set("name", (Object)this.name);
        section.set("owner", (Object)this.owner.getUniqueId().toString());
        section.set("world", (Object)"");
        ConfigurationSection sec = section.getConfigurationSection("chunks");
        if (sec == null) {
            sec = section.createSection("chunks");
        }
        Iterator<ChunkReference> iterator = this.chunks.iterator();
        for (int i = 0; i < this.chunks.size(); ++i) {
            ChunkReference chunkReference = iterator.next();
            String key = Integer.toString(i);
            ConfigurationSection sc = sec.getConfigurationSection(key);
            if (sc == null) {
                sc = sec.createSection(key);
            }
            sc.set("x", (Object)chunkReference.x);
            sc.set("z", (Object)chunkReference.z);
            if (i != 0) continue;
            section.set("world", (Object)chunkReference.world.getName());
        }
        sec = section.getConfigurationSection("permissions");
        if (sec == null) {
            sec = section.createSection("permissions");
        }
        for (Map.Entry<Permission, TrustLevel> entry : this.globalPerms.entrySet()) {
            sec.set(entry.getKey().name(), (Object)entry.getValue().name());
        }
        sec = section.getConfigurationSection("users");
        if (sec == null) {
            sec = section.createSection("users");
        }
        for (Map.Entry<Object, Object> entry : this.playerPerms.entrySet()) {
            List list = ((EnumSet)entry.getValue()).stream().flatMap(p -> Stream.of(p.name())).collect(Collectors.toList());
            sec.set(((UUID)entry.getKey()).toString(), list);
        }
        if (this.graceStart > 0L) {
            section.set("graceStart", (Object)this.graceStart);
        }
    }

    private void updateHandlers() {
        if (!this.manageHandlers) {
            return;
        }
        EnumSet<Permission> inUse = EnumSet.noneOf(Permission.class);
        for (Permission p : Permission.values()) {
            if (Objects.equals((Object)this.globalPerms.get((Object)p), (Object)TrustLevel.ALL)) continue;
            inUse.add(p);
        }
        for (EnumSet enumSet : this.playerPerms.values()) {
            inUse.addAll(enumSet);
        }
        for (Object key : this.handlers.keySet().toArray()) {
            Permission perm = (Permission)((Object)key);
            if (inUse.contains((Object)perm)) {
                inUse.remove((Object)perm);
                continue;
            }
            this.handlers.remove((Object)perm).unregister();
        }
        for (Permission permission : inUse) {
            if (!permission.hasHandler()) continue;
            PermissionHandler handler = permission.createHandler(this);
            handler.register();
            this.handlers.put(permission, handler);
        }
    }

    private void removeHandlers() {
        for (PermissionHandler handler : this.handlers.values()) {
            handler.unregister();
        }
        this.handlers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean claim() {
        boolean added;
        String myToken = this.getUniqueToken();
        for (RegistryEntry re : new HashSet<RegistryEntry>(registry)) {
            Claim c = re.claim();
            if (c == this) continue;
            if (c.getUniqueToken().equals(myToken)) {
                c.unclaim();
                continue;
            }
            for (Object object : c.chunks.toArray()) {
                ChunkReference chunk = (ChunkReference)object;
                if (!this.chunks.contains(chunk)) continue;
                c.removeChunk(chunk);
            }
        }
        this.manageHandlers = true;
        registryLock.writeLock().lock();
        try {
            added = registry.add(RegistryEntry.of(this));
        }
        finally {
            registryLock.writeLock().unlock();
        }
        if (added) {
            this.updateHandlers();
            this.validateMarkers();
            return true;
        }
        return false;
    }

    public boolean unclaim() {
        boolean removed;
        this.manageHandlers = false;
        registryLock.writeLock().lock();
        try {
            removed = registry.remove(RegistryEntry.of(this));
        }
        finally {
            registryLock.writeLock().unlock();
        }
        if (removed) {
            this.removeHandlers();
            this.ownerChangeCallbacks.clear();
            if (MapService.isAvailable()) {
                MapService ms = MapService.getNonNull();
                ms.queueOperation(MapServiceOp.delete(this));
            }
            return true;
        }
        return false;
    }

    public boolean isCanonical() {
        registryLock.readLock().lock();
        try {
            boolean bl = registry.contains(RegistryEntry.of(this));
            return bl;
        }
        finally {
            registryLock.readLock().unlock();
        }
    }

    public int hashCode() {
        return RegistryEntry.of(this).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Claim) {
            return RegistryEntry.of(this).equals(RegistryEntry.of((Claim)obj));
        }
        return super.equals(obj);
    }

    private static interface RegistryEntry {
        @NotNull
        public static RegistryEntry of(@NotNull Claim claim) {
            return new Real(claim);
        }

        @NotNull
        public static RegistryEntry fake(@NotNull CharSequence string) {
            return new Fake(string);
        }

        @NotNull
        public CharSequence claimName();

        public boolean claimNameEquals(@NotNull CharSequence var1, boolean var2);

        default public boolean claimNameEquals(@NotNull CharSequence other) {
            return this.claimNameEquals(other, true);
        }

        @NotNull
        public Claim claim() throws UnsupportedOperationException;

        public static final class Real
        extends Abstract {
            private final Claim value;

            Real(@NotNull Claim value) {
                this.value = value;
            }

            @Override
            @NotNull
            public String claimName() {
                return this.value.name;
            }

            @Override
            @NotNull
            public Claim claim() {
                return this.value;
            }
        }

        public static final class Fake
        extends Abstract {
            private final CharSequence name;

            Fake(@NotNull CharSequence name) {
                this.name = name;
            }

            @Override
            @NotNull
            public CharSequence claimName() {
                return this.name;
            }

            @Override
            @Contract(value=" -> fail")
            @NotNull
            public Claim claim() {
                throw new UnsupportedOperationException();
            }
        }

        public static abstract class Abstract
        implements RegistryEntry {
            @Override
            public boolean claimNameEquals(@NotNull CharSequence b, boolean ignoreCase) {
                CharSequence a = this.claimName();
                int al = a.length();
                if (al == 0) {
                    return false;
                }
                int bl = b.length();
                if (al != bl) {
                    return false;
                }
                for (int i = 0; i < al; ++i) {
                    char ca = a.charAt(i);
                    if (ignoreCase) {
                        ca = Character.toLowerCase(ca);
                    }
                    char cb = b.charAt(i);
                    if (ignoreCase) {
                        cb = Character.toLowerCase(cb);
                    }
                    if (ca == cb) continue;
                    return false;
                }
                return true;
            }

            public int hashCode() {
                PrimitiveIterator.OfInt name = this.claimName().codePoints().iterator();
                int hash = 7;
                while (name.hasNext()) {
                    hash = 31 * hash + Character.toLowerCase(name.nextInt());
                }
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof RegistryEntry && this.claimNameEquals(((RegistryEntry)obj).claimName())) {
                    return true;
                }
                return super.equals(obj);
            }
        }
    }
}

