/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim;

import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.GraceRoutine;
import codes.wasabi.xclaim.api.MovementRoutine;
import codes.wasabi.xclaim.command.CommandManager;
import codes.wasabi.xclaim.command.argument.type.OfflinePlayerType;
import codes.wasabi.xclaim.command.sub.UpdateCommand;
import codes.wasabi.xclaim.config.impl.defaulting.DefaultingRootConfig;
import codes.wasabi.xclaim.config.impl.toml.TomlRootConfig;
import codes.wasabi.xclaim.config.impl.yaml.YamlRootConfig;
import codes.wasabi.xclaim.config.struct.RootConfig;
import codes.wasabi.xclaim.config.struct.helpers.ToggleableConfig;
import codes.wasabi.xclaim.config.struct.sub.AutoSaveConfig;
import codes.wasabi.xclaim.config.struct.sub.EditorConfig;
import codes.wasabi.xclaim.config.struct.sub.IntegrationsConfig;
import codes.wasabi.xclaim.config.struct.sub.RulesConfig;
import codes.wasabi.xclaim.config.struct.sub.WorldsConfig;
import codes.wasabi.xclaim.config.struct.sub.integrations.EconomyConfig;
import codes.wasabi.xclaim.config.struct.sub.integrations.MapConfig;
import codes.wasabi.xclaim.debug.Debuggable;
import codes.wasabi.xclaim.debug.goal.DebugGoal;
import codes.wasabi.xclaim.debug.writer.DebugWriter;
import codes.wasabi.xclaim.economy.Economy;
import codes.wasabi.xclaim.gui.ChunkEditor;
import codes.wasabi.xclaim.gui2.GuiService;
import codes.wasabi.xclaim.map.MapService;
import codes.wasabi.xclaim.particle.ParticleService;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.platform.PlatformSchedulerTask;
import codes.wasabi.xclaim.shadow.bstats.bukkit.Metrics;
import codes.wasabi.xclaim.shadow.kyori.adventure.audience.Audience;
import codes.wasabi.xclaim.shadow.kyori.adventure.platform.bukkit.BukkitAudiences;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.minimessage.MiniMessage;
import codes.wasabi.xclaim.shadow.toml.Toml;
import codes.wasabi.xclaim.util.StreamUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debuggable
public final class XClaim
extends JavaPlugin {
    public static XClaim instance;
    public static Logger logger;
    public static File trustFile;
    public static YamlConfiguration trustConfig;
    public static File claimsFile;
    public static YamlConfiguration claimsConfig;
    public static RootConfig mainConfig;
    public static CommandManager commandManager;
    public static File jarFile;
    public static File dataFolder;
    public static Lang lang;
    public static GuiService gui;
    private static final String[] bundledLangs;
    private PlatformSchedulerTask autosaveTask = null;
    private boolean performedAnyLoad = false;

    public void onEnable() {
        instance = this;
        logger = this.getLogger();
        this.loadMainConfig();
        this.setupLang();
        Platform.init();
        if (mainConfig.isLegacy()) {
            this.warnConfigMigration();
        }
        if (!Economy.isAvailable() && mainConfig.integrations().economy().enabled().booleanValue()) {
            logger.log(Level.WARNING, lang.get("eco-fail"));
        }
        if ((dataFolder = this.getDataFolder()).mkdirs()) {
            logger.log(Level.INFO, lang.get("data-folder-created"));
        }
        ParticleService.init();
        this.locateJarFile();
        this.loadDynmap();
        this.loadTrustedPlayers();
        this.loadClaims();
        this.startServices();
        logger.log(Level.INFO, lang.get("startup-done"));
        this.checkForUpdates();
    }

    public void onDisable() {
        this.saveTrustedPlayers();
        this.saveClaims(false);
        this.stopServices();
        Platform.cleanup();
        logger.log(Level.INFO, lang.get("disable-done"));
    }

    private void locateJarFile() {
        logger.log(Level.INFO, lang.get("locating-jar"));
        jarFile = new File(XClaim.class.getProtectionDomain().getCodeSource().getLocation().getPath());
    }

    private void loadMainConfig() {
        File dataDir = this.getDataFolder();
        boolean dataDirExists = dataDir.isDirectory();
        File config = new File(dataDir, "config.toml");
        File legacyConfig = new File(dataDir, "config.yml");
        mainConfig = new DefaultingRootConfig(this.loadMainConfigInternal(dataDir, dataDirExists, config, legacyConfig));
    }

    @NotNull
    private RootConfig loadMainConfigInternal(File dataDir, boolean dataDirExists, File config, File legacyConfig) {
        if (!dataDirExists && !dataDir.mkdirs()) {
            throw new AssertionError((Object)"Data directory does not exist and could not be created");
        }
        if (!dataDirExists || !config.isFile()) {
            try (InputStream is = Objects.requireNonNull(this.getResource("config.toml"));
                 FileOutputStream os = new FileOutputStream(config, false);){
                IOUtils.copyLarge(is, os);
            }
            catch (IOException e) {
                throw new AssertionError("Failed to write config.toml to disk", e);
            }
        }
        AssertionError suppressed = null;
        if (dataDirExists && legacyConfig.isFile()) {
            try {
                YamlConfiguration handle = new YamlConfiguration();
                handle.load(legacyConfig);
                return new YamlRootConfig((ConfigurationSection)handle);
            }
            catch (Exception e) {
                suppressed = new AssertionError("Failed to load config file \"" + legacyConfig.getName() + "\"", e);
            }
        }
        Toml toml = new Toml();
        try (FileInputStream is = new FileInputStream(config);
             InputStreamReader reader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);){
            toml.read(reader);
        }
        catch (Exception e) {
            AssertionError ex = new AssertionError("Failed to read config.toml", e);
            if (suppressed != null) {
                ((Throwable)((Object)ex)).addSuppressed((Throwable)((Object)suppressed));
            }
            throw ex;
        }
        return new TomlRootConfig(toml);
    }

    private void setupLang() {
        String l = mainConfig.language();
        File f = this.getDataFolder();
        File langFolder = new File(f, "lang");
        if (!langFolder.exists()) {
            try {
                if (!langFolder.mkdirs()) {
                    throw new IOException("Could not create directory");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!langFolder.isDirectory()) {
            try {
                FileUtils.forceDelete(langFolder);
                if (!langFolder.mkdirs()) {
                    throw new IOException("Could not create directory");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (String bundled : bundledLangs) {
            JsonObject curJson;
            File bundledFile = new File(langFolder, bundled + ".json");
            boolean exists = bundledFile.exists();
            if (exists) {
                try {
                    curJson = (JsonObject)gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(bundledFile), StandardCharsets.UTF_8), JsonObject.class);
                }
                catch (Exception e) {
                    curJson = new JsonObject();
                }
            } else {
                curJson = new JsonObject();
                try {
                    if (!bundledFile.createNewFile()) {
                        throw new IOException();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to create \"" + bundledFile.getPath() + "\", continuing...");
                }
            }
            try {
                byte[] verbatim;
                boolean canCopyVerbatim = true;
                try (InputStream is = Objects.requireNonNull(this.getResource("lang/" + bundled + ".json"));){
                    verbatim = StreamUtil.readAllBytes(is);
                    if (exists) {
                        JsonObject model = (JsonObject)gson.fromJson(new String(verbatim, StandardCharsets.UTF_8), JsonObject.class);
                        for (Map.Entry entry : model.entrySet()) {
                            String key = (String)entry.getKey();
                            if (!curJson.has(key)) {
                                curJson.add(key, (JsonElement)entry.getValue());
                                continue;
                            }
                            if (Objects.equals(curJson.get(key), entry.getValue())) continue;
                            canCopyVerbatim = false;
                        }
                    }
                }
                try (FileOutputStream os = new FileOutputStream(bundledFile, false);){
                    if (canCopyVerbatim) {
                        ((OutputStream)os).write(verbatim);
                    } else {
                        String json = gson.toJson((JsonElement)curJson);
                        ((OutputStream)os).write(json.getBytes(StandardCharsets.UTF_8));
                    }
                    os.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File langToUse = new File(langFolder, l + ".json");
        if (!langToUse.exists()) {
            langToUse = new File(langFolder, "en-US.json");
        }
        try (FileInputStream is = new FileInputStream(langToUse);){
            byte[] bytes = StreamUtil.readAllBytes(is);
            String string = new String(bytes, StandardCharsets.UTF_8);
            JsonObject ob = (JsonObject)gson.fromJson(string, JsonObject.class);
            lang = new Lang(ob);
        }
        catch (Exception e) {
            e.printStackTrace();
            lang = new Lang(new JsonObject());
        }
    }

    private void loadDynmap() {
        if (mainConfig.integrations().map().enabled().booleanValue()) {
            logger.log(Level.INFO, lang.get("dynmap-check"));
            MapService.get();
        }
    }

    private void loadTrustedPlayers() {
        logger.log(Level.INFO, lang.get("trust-load"));
        trustFile = new File(dataFolder, "trust.yml");
        trustConfig = new YamlConfiguration();
        try {
            trustConfig.load(trustFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            logger.log(Level.WARNING, lang.get("trust-load-err"));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClaims() {
        if (this.autosaveTask != null) {
            this.autosaveTask.cancel();
        }
        try {
            double interval;
            logger.log(Level.INFO, lang.get("claims-load"));
            claimsFile = new File(dataFolder, "claims.yml");
            claimsConfig = new YamlConfiguration();
            try {
                claimsConfig.load(claimsFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                logger.log(Level.WARNING, lang.get("claims-load-err"));
                e.printStackTrace();
            }
            logger.log(Level.INFO, lang.get("claims-unpack"));
            for (String key : claimsConfig.getKeys(false)) {
                Claim claim;
                ConfigurationSection section = claimsConfig.getConfigurationSection(key);
                if (section == null) {
                    logger.log(Level.WARNING, lang.get("claims-unpack-err", key, lang.get("claims-unpack-err-section")));
                    continue;
                }
                try {
                    claim = Claim.deserialize(section);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    logger.log(Level.WARNING, lang.get("claims-unpack-err", key, e.getClass().getSimpleName()));
                    continue;
                }
                claim.claim();
            }
            if (mainConfig.autoSave().enabled().booleanValue() && (interval = (double)mainConfig.autoSave().interval().longValue()) > 0.0) {
                long intervalTicks = Math.round(interval * 20.0);
                this.autosaveTask = Platform.get().getScheduler().runTaskTimer((Plugin)this, this::autoSaveClaims, 0L, intervalTicks);
            }
        }
        finally {
            this.performedAnyLoad = true;
        }
    }

    private void startServices() {
        Metrics metrics = new Metrics((Plugin)this, 16129);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            try {
                Class<?> clazz = Class.forName("codes.wasabi.xclaim.placeholder.XClaimPlaceholderExpansion");
                Constructor<?> con = clazz.getConstructor(XClaim.class);
                Object expansion = con.newInstance(new Object[]{this});
                Method registerMethod = clazz.getMethod("register", new Class[0]);
                registerMethod.invoke(expansion, new Object[0]);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to bind placeholders", e);
            }
        }
        gui = GuiService.create(mainConfig.gui().version());
        gui.start();
        logger.log(Level.INFO, lang.get("services-chunk-editor"));
        ChunkEditor.initialize();
        logger.log(Level.INFO, lang.get("services-command"));
        OfflinePlayerType.initializeListener();
        commandManager = new CommandManager();
        logger.log(Level.INFO, lang.get("services-command-register"));
        commandManager.registerDefaults();
        logger.log(Level.INFO, lang.get("services-movement"));
        MovementRoutine.initialize();
        logger.log(Level.INFO, lang.get("services-grace"));
        GraceRoutine.refresh();
    }

    private void checkForUpdates() {
        Platform.get().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String option = UpdateCommand.initialCheck();
            if (option == null) {
                return;
            }
            this.broadcastConsoleOps(lang.getComponent("update-available-line1", option), lang.getComponent("update-available-line2"));
        });
    }

    private void warnConfigMigration() {
        this.broadcastConsoleOps(lang.getComponent("config-migration-line1"), lang.getComponent("config-migration-line2"));
    }

    private void broadcastConsoleOps(Component ... messages) {
        Platform.get().getScheduler().synchronize(() -> {
            BukkitAudiences adventure = Platform.getAdventure();
            Audience au = adventure.console();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.isOp()) continue;
                au = Audience.audience(au, adventure.player(p));
            }
            for (Component message : messages) {
                au.sendMessage(message);
            }
        });
    }

    private void saveTrustedPlayers() {
        logger.log(Level.INFO, lang.get("trust-save"));
        try {
            if (!trustFile.exists() && trustFile.createNewFile()) {
                logger.log(Level.INFO, lang.get("trust-save-new"));
            }
            trustConfig.save(trustFile);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, lang.get("trust-save-err"));
            e.printStackTrace();
        }
    }

    private void autoSaveClaims() {
        this.saveClaims(this.getConfig().getBoolean("auto-save.silent", false));
    }

    private void saveClaims(boolean silent) {
        block8: {
            if (!this.performedAnyLoad) {
                return;
            }
            if (!silent) {
                logger.log(Level.INFO, lang.get("claims-save"));
            }
            Set removeKeys = claimsConfig.getKeys(false);
            for (Claim claim : Claim.getAll()) {
                String token = claim.getUniqueToken();
                ConfigurationSection section = claimsConfig.getConfigurationSection(token);
                if (section == null) {
                    section = claimsConfig.createSection(token);
                }
                claim.serialize(section);
                removeKeys.remove(token);
            }
            for (String key : removeKeys) {
                claimsConfig.set(key, null);
            }
            try {
                if (!claimsFile.exists() && claimsFile.createNewFile() && !silent) {
                    logger.log(Level.INFO, lang.get("claims-save-new"));
                }
                claimsConfig.save(claimsFile);
            }
            catch (Exception e) {
                if (silent) break block8;
                logger.log(Level.WARNING, lang.get("claims-save-err"), e);
            }
        }
    }

    private void stopServices() {
        logger.log(Level.INFO, lang.get("services-stop"));
        if (mainConfig.editor().stopOnShutdown().booleanValue()) {
            for (Player ply : Bukkit.getOnlinePlayers()) {
                ChunkEditor.stopEditing(ply);
            }
        }
        commandManager.unregisterAll();
        OfflinePlayerType.clearListener();
        MovementRoutine.cleanup();
        GraceRoutine.stop();
        gui.stop();
        MapService.unload();
        if (this.autosaveTask != null) {
            this.autosaveTask.cancel();
        }
    }

    @DebugGoal(async=true)
    static void config(@NotNull DebugWriter writer) {
        writer.color(NamedTextColor.GOLD);
        writer.println("Impl: " + mainConfig.getClass().getName());
        writer.println("----------------");
        writer.println();
        XClaim.config0(writer, mainConfig);
        writer.println();
        XClaim.config1(writer, mainConfig.autoSave());
        writer.println();
        XClaim.config2(writer, mainConfig.editor());
        writer.println();
        XClaim.config3(writer, mainConfig.integrations());
        writer.println();
        XClaim.config4(writer, mainConfig.rules());
        writer.println();
        XClaim.config5(writer, mainConfig.worlds());
        writer.println();
    }

    private static void config0(@NotNull DebugWriter writer, @NotNull RootConfig cfg) {
        writer.color(NamedTextColor.AQUA);
        writer.println("[root]");
        writer.color(NamedTextColor.WHITE);
        writer.println("language = " + cfg.language());
        writer.println("veteran-time = " + cfg.veteranTime());
        writer.println("no-paper-nag = " + cfg.noPaperNag());
    }

    private static void config1(@NotNull DebugWriter writer, @NotNull AutoSaveConfig cfg) {
        writer.color(NamedTextColor.AQUA);
        writer.println("[auto-save]");
        writer.color(NamedTextColor.WHITE);
        writer.println("enabled = " + cfg.enabled());
        writer.println("debug = " + cfg.debug());
        writer.println("interval = " + cfg.interval());
        writer.println("silent = " + cfg.silent());
    }

    private static void config2(@NotNull DebugWriter writer, @NotNull EditorConfig cfg) {
        writer.color(NamedTextColor.AQUA);
        writer.println("[editor]");
        writer.color(NamedTextColor.WHITE);
        writer.println("start-on-create = " + cfg.startOnCreate());
        writer.println("stop-on-shutdown = " + cfg.stopOnShutdown());
        writer.println("stop-on-leave = " + cfg.stopOnLeave());
    }

    private static void config3(@NotNull DebugWriter writer, @NotNull IntegrationsConfig cfg) {
        writer.color(NamedTextColor.AQUA);
        writer.println("[integrations.economy]");
        writer.color(NamedTextColor.WHITE);
        XClaim.config30(writer, cfg.economy());
        writer.println();
        writer.color(NamedTextColor.AQUA);
        writer.println("[integrations.map]");
        writer.color(NamedTextColor.WHITE);
        XClaim.config31(writer, cfg.map());
        writer.println();
        writer.color(NamedTextColor.AQUA);
        writer.println("[integrations.protection]");
        writer.color(NamedTextColor.WHITE);
        XClaim.config300(writer, cfg.protection());
    }

    private static void config300(@NotNull DebugWriter writer, @NotNull ToggleableConfig cfg) {
        writer.println("enabled = " + cfg.enabled());
        writer.println("debug = " + cfg.debug());
    }

    private static void config30(@NotNull DebugWriter writer, @NotNull EconomyConfig cfg) {
        XClaim.config300(writer, cfg);
        writer.println("claim-price.default = " + cfg.claimPrice(null));
        writer.println("unclaim-reward.default = " + cfg.unclaimReward(null));
        writer.println("free-chunks.default = " + cfg.freeChunks(null));
    }

    private static void config31(@NotNull DebugWriter writer, @NotNull MapConfig cfg) {
        XClaim.config300(writer, cfg);
        writer.println("old-outline-style = " + cfg.oldOutlineStyle());
    }

    private static void config4(@NotNull DebugWriter writer, @NotNull RulesConfig cfg) {
        writer.color(NamedTextColor.AQUA);
        writer.println("[rules]");
        writer.color(NamedTextColor.WHITE);
        writer.println("placement = " + cfg.placementRaw() + " (" + cfg.placement().name() + ")");
        writer.println("min-distance = " + cfg.minDistance());
        writer.println("exempt-owner = " + cfg.exemptOwner());
        writer.println("max-chunks.default = " + cfg.maxChunks(null));
        writer.println("max-claims.default = " + cfg.maxClaims(null));
        writer.println("max-claims-in-world.default = " + cfg.maxClaimsInWorld(null));
    }

    private static void config5(@NotNull DebugWriter writer, @NotNull WorldsConfig cfg) {
        writer.color(NamedTextColor.AQUA);
        writer.println("[worlds]");
        writer.color(NamedTextColor.WHITE);
        writer.println("grace-time = " + cfg.graceTime());
        writer.println("use-whitelist = " + cfg.useWhitelist());
        writer.println("whitelist = " + Arrays.toString(cfg.whitelist().toArray()));
        writer.println("use-blacklist = " + cfg.useBlacklist());
        writer.println("whitelist = " + Arrays.toString(cfg.blacklist().toArray()));
        writer.println("case-sensitive = " + cfg.caseSensitive());
    }

    static {
        bundledLangs = new String[]{"en-US", "de", "zh", "tr"};
    }

    public static class Lang {
        private static final Pattern pattern = Pattern.compile("(\\$\\d+)");
        private static final MiniMessage mm = MiniMessage.miniMessage();
        private static final MiniMessage strict = MiniMessage.builder().strict(true).build();
        private final Map<String, String> map = new HashMap<String, String>();

        Lang(JsonObject ob) {
            for (Map.Entry entry : ob.entrySet()) {
                JsonPrimitive primitive;
                JsonElement value = (JsonElement)entry.getValue();
                if (!value.isJsonPrimitive() || !(primitive = (JsonPrimitive)value).isString()) continue;
                this.map.put((String)entry.getKey(), primitive.getAsString());
            }
        }

        @Nullable
        private String rawGet(String key) {
            return this.map.get(key);
        }

        public boolean has(String key) {
            return this.map.containsKey(key);
        }

        public String get(String key) {
            return this.get(key, new String[0]);
        }

        public String get(String key, String ... args) {
            String base = this.rawGet(key);
            if (base != null) {
                StringBuilder out = new StringBuilder();
                StringBuilder term = null;
                boolean buildingTerm = false;
                for (char c : base.toCharArray()) {
                    if (buildingTerm) {
                        if (c >= '0' && c <= '9') {
                            term.append(c);
                            continue;
                        }
                        buildingTerm = false;
                        String brk = term.toString();
                        try {
                            int val = Integer.parseInt(brk);
                            if (val < 1 || val > args.length) {
                                throw new IllegalArgumentException();
                            }
                            String arg = args[val - 1];
                            out.append(arg);
                        }
                        catch (Exception e) {
                            out.append("$").append((CharSequence)term);
                        }
                        out.append(c);
                        continue;
                    }
                    if (c == '$') {
                        buildingTerm = true;
                        term = new StringBuilder();
                        continue;
                    }
                    out.append(c);
                }
                if (buildingTerm) {
                    String brk = term.toString();
                    try {
                        int val = Integer.parseInt(brk);
                        if (val < 1 || val > args.length) {
                            throw new IllegalArgumentException();
                        }
                        String arg = args[val - 1];
                        out.append(arg);
                    }
                    catch (Exception e) {
                        out.append("$").append((CharSequence)term);
                    }
                }
                return out.toString();
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(args[i]);
            }
            return sb.toString();
        }

        public String get(String key, int ... args) {
            String[] argStrings = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                argStrings[i] = String.valueOf(args[i]);
            }
            return this.get(key, argStrings);
        }

        public Component getComponent(String key) {
            String string = this.get(key);
            return mm.deserialize(string);
        }

        public Component getComponent(String key, Component ... args) {
            String[] argStrings = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                argStrings[i] = (String)strict.serializeOrNull(args[i]);
            }
            String string = this.get(key, argStrings);
            return mm.deserialize(string);
        }

        public Component getComponent(String key, String ... args) {
            String string = this.get(key, args);
            return mm.deserialize(string);
        }

        public Component getComponent(String key, int ... args) {
            String string = this.get(key, args);
            return mm.deserialize(string);
        }
    }
}

