/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.util;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.utils.FormatUtil;
import com.google.common.base.Splitter;
import java.time.Instant;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.essentialsx.dep.net.dv8tion.jda.api.utils.TimeFormat;
import net.essentialsx.discord.EssentialsDiscord;
import net.essentialsx.discord.JDADiscordService;
import net.essentialsx.discord.util.MessageUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.bukkit.Bukkit;

@Plugin(name="EssentialsX-ConsoleInjector", category="Core", elementType="appender", printObject=true)
public class ConsoleInjector
extends AbstractAppender {
    private static final Logger logger = EssentialsDiscord.getWrappedLogger();
    private static final long QUEUE_PROCESS_PERIOD_SECONDS = 2L;
    private final JDADiscordService jda;
    private final BlockingQueue<String> messageQueue = new LinkedBlockingQueue<String>();
    private final int taskId;
    private boolean removed = false;
    private final AtomicLong lastRateLimitTime = new AtomicLong(0L);
    private final AtomicInteger recentRateLimit = new AtomicInteger(0);
    private final AtomicInteger totalBackoffEvents = new AtomicInteger();

    public ConsoleInjector(JDADiscordService jda) {
        super("EssentialsX-ConsoleInjector", null, null, false);
        this.jda = jda;
        ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).addAppender((Appender)this);
        this.taskId = Bukkit.getScheduler().runTaskTimerAsynchronously((org.bukkit.plugin.Plugin)jda.getPlugin(), () -> {
            String curLine;
            if (this.recentRateLimit.get() < 0) {
                if (this.totalBackoffEvents.get() * 20 >= jda.getSettings().getConsoleSkipDelay() * 60) {
                    logger.warning("EssXBackoff: Reached console skip delay, attempt to skip");
                    jda.getConsoleWebhook().abandonRequests();
                    this.messageQueue.clear();
                    this.totalBackoffEvents.set(0);
                    this.recentRateLimit.set(0);
                    this.lastRateLimitTime.set(0L);
                    return;
                }
                int backoff = this.recentRateLimit.incrementAndGet();
                if (jda.isDebug()) {
                    logger.warning("EssXBackoff: Webhook backoff in progress, skipping queue processing. Resuming in " + Math.abs(backoff) + " cycles.");
                }
                return;
            }
            StringBuilder buffer = new StringBuilder();
            while ((curLine = (String)this.messageQueue.peek()) != null) {
                if (buffer.length() + curLine.length() > 1998) {
                    this.sendMessage(buffer.toString());
                    buffer.setLength(0);
                    continue;
                }
                buffer.append("\n").append((String)this.messageQueue.poll());
            }
            if (buffer.length() != 0) {
                this.sendMessage(buffer.toString());
            }
        }, 20L, 40L).getTaskId();
    }

    private void sendMessage(String content) {
        this.jda.getConsoleWebhook().send(this.jda.getWebhookMessage(content)).exceptionally(e -> {
            logger.severe(I18n.tl((String)"discordErrorWebhook", (Object[])new Object[0]));
            this.remove();
            return null;
        });
    }

    public void append(LogEvent event) {
        String[] loggerNameSplit;
        String loggerName;
        if (event.getLevel().intLevel() > this.jda.getSettings().getConsoleLogLevel().intLevel()) {
            return;
        }
        String entry = FormatUtil.stripPaper((String)FormatUtil.stripFormat((String)FormatUtil.stripAnsi((String)event.getMessage().getFormattedMessage()))).trim();
        if (entry.isEmpty()) {
            return;
        }
        if (entry.startsWith("EssXBackoff: ")) {
            return;
        }
        if (event.getLoggerName().contains("net.essentialsx.dep.club.minnced.discord.webhook.WebhookClient") && entry.startsWith("Encountered 429, retrying after ")) {
            if (this.recentRateLimit.get() >= 0) {
                this.recentRateLimit.incrementAndGet();
            }
            if (this.lastRateLimitTime.get() == 0L || System.currentTimeMillis() - this.lastRateLimitTime.get() > 5000L) {
                this.lastRateLimitTime.set(System.currentTimeMillis());
                if (this.recentRateLimit.get() >= 0) {
                    this.recentRateLimit.set(0);
                }
            } else if (this.recentRateLimit.get() >= 2) {
                if (this.jda.isDebug()) {
                    this.totalBackoffEvents.getAndIncrement();
                    logger.warning("EssXBackoff: Beginning Webhook Backoff");
                }
                this.recentRateLimit.set(-20);
            }
            return;
        }
        if (!this.jda.getSettings().getConsoleFilters().isEmpty()) {
            for (Pattern pattern : this.jda.getSettings().getConsoleFilters()) {
                if (!pattern.matcher(entry).find()) continue;
                return;
            }
        }
        if (!(loggerName = (loggerNameSplit = event.getLoggerName().split("\\."))[loggerNameSplit.length - 1].trim()).isEmpty()) {
            entry = "[" + loggerName + "] " + entry;
        }
        this.messageQueue.addAll(Splitter.fixedLength((int)1950).splitToList((CharSequence)MessageUtil.formatMessage(this.jda.getSettings().getConsoleFormat(), TimeFormat.TIME_LONG.format(Instant.now()), event.getLevel().name(), MessageUtil.sanitizeDiscordMarkdown(entry))));
    }

    public void remove() {
        ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).removeAppender((Appender)this);
        Bukkit.getScheduler().cancelTask(this.taskId);
        this.messageQueue.clear();
        if (this.jda.getConsoleWebhook() != null && !this.jda.getConsoleWebhook().isShutdown()) {
            this.jda.getConsoleWebhook().close();
        }
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }
}

