/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.listeners;

import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.ChannelType;
import net.essentialsx.dep.net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.essentialsx.dep.net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.essentialsx.discord.JDADiscordService;
import net.essentialsx.discord.util.DiscordCommandSender;
import net.essentialsx.discord.util.DiscordUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DiscordCommandDispatcher
extends ListenerAdapter {
    private final JDADiscordService jda;
    private String channelId = null;

    public DiscordCommandDispatcher(JDADiscordService jda) {
        this.jda = jda;
    }

    @Override
    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        if (event.getMessage().getChannelType() != ChannelType.TEXT) {
            return;
        }
        if (this.jda.getConsoleWebhook() != null && event.getChannel().getId().equals(this.channelId)) {
            if ((event.isWebhookMessage() || event.getAuthor().isBot()) && (!this.jda.getSettings().isConsoleBotCommandRelay() || DiscordUtil.ACTIVE_WEBHOOKS.contains(event.getAuthor().getId()) || event.getAuthor().getId().equals(event.getGuild().getSelfMember().getId()))) {
                return;
            }
            String command = event.getMessage().getContentRaw();
            Bukkit.getScheduler().runTask((Plugin)this.jda.getPlugin(), () -> {
                try {
                    Bukkit.dispatchCommand((CommandSender)new DiscordCommandSender(this.jda, Bukkit.getConsoleSender(), message -> event.getMessage().reply(message).queue()).getSender(), (String)command);
                }
                catch (CommandException e) {
                    if (e.getMessage().contains("a vanilla command listener") || e.getCause() != null && e.getCause().getMessage().contains("a vanilla command listener")) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                        return;
                    }
                    throw e;
                }
            });
        }
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }
}

