/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.listeners;

import com.earth2me.essentials.Console;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.text.MessageFormat;
import java.util.UUID;
import net.ess3.api.IUser;
import net.ess3.api.events.AfkStatusChangeEvent;
import net.ess3.api.events.MuteStatusChangeEvent;
import net.ess3.api.events.VanishStatusChangeEvent;
import net.ess3.provider.AbstractAchievementEvent;
import net.essentialsx.api.v2.events.AsyncUserDataLoadEvent;
import net.essentialsx.api.v2.events.UserActionEvent;
import net.essentialsx.api.v2.events.discord.DiscordMessageEvent;
import net.essentialsx.api.v2.services.discord.MessageType;
import net.essentialsx.discord.JDADiscordService;
import net.essentialsx.discord.util.DiscordUtil;
import net.essentialsx.discord.util.MessageUtil;
import org.bukkit.ChatColor;
import org.bukkit.GameRule;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class BukkitListener
implements Listener {
    private final JDADiscordService jda;

    public BukkitListener(JDADiscordService jda) {
        this.jda = jda;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDiscordMessage(DiscordMessageEvent event) {
        this.jda.sendMessage(event, event.getMessage(), event.isAllowGroupMentions());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMute(MuteStatusChangeEvent event) {
        if (!event.getValue()) {
            this.sendDiscordMessage(MessageType.DefaultTypes.MUTE, MessageUtil.formatMessage(this.jda.getSettings().getUnmuteFormat(), MessageUtil.sanitizeDiscordMarkdown(event.getAffected().getName()), MessageUtil.sanitizeDiscordMarkdown(event.getAffected().getDisplayName())));
        } else if (event.getTimestamp().isPresent()) {
            boolean console = event.getController() == null;
            MessageFormat msg = event.getReason() == null ? this.jda.getSettings().getTempMuteFormat() : this.jda.getSettings().getTempMuteReasonFormat();
            this.sendDiscordMessage(MessageType.DefaultTypes.MUTE, MessageUtil.formatMessage(msg, MessageUtil.sanitizeDiscordMarkdown(event.getAffected().getName()), MessageUtil.sanitizeDiscordMarkdown(event.getAffected().getDisplayName()), MessageUtil.sanitizeDiscordMarkdown(console ? "Console" : event.getController().getName()), MessageUtil.sanitizeDiscordMarkdown(console ? Console.DISPLAY_NAME : event.getController().getDisplayName()), DateUtil.formatDateDiff((long)((Long)event.getTimestamp().get())), MessageUtil.sanitizeDiscordMarkdown(event.getReason())));
        } else {
            boolean console = event.getController() == null;
            MessageFormat msg = event.getReason() == null ? this.jda.getSettings().getPermMuteFormat() : this.jda.getSettings().getPermMuteReasonFormat();
            this.sendDiscordMessage(MessageType.DefaultTypes.MUTE, MessageUtil.formatMessage(msg, MessageUtil.sanitizeDiscordMarkdown(event.getAffected().getName()), MessageUtil.sanitizeDiscordMarkdown(event.getAffected().getDisplayName()), MessageUtil.sanitizeDiscordMarkdown(console ? "Console" : event.getController().getName()), MessageUtil.sanitizeDiscordMarkdown(console ? Console.DISPLAY_NAME : event.getController().getDisplayName()), MessageUtil.sanitizeDiscordMarkdown(event.getReason())));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(AsyncUserDataLoadEvent event) {
        if (!this.isSilentJoinQuit(event.getUser(), "join") && !this.isVanishHide(event.getUser())) {
            if (!event.getUser().getBase().hasPlayedBefore()) {
                this.sendJoinQuitMessage(event.getUser().getBase(), event.getJoinMessage(), MessageType.DefaultTypes.FIRST_JOIN);
            } else {
                this.sendJoinQuitMessage(event.getUser().getBase(), event.getJoinMessage(), MessageType.DefaultTypes.JOIN);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onQuit(PlayerQuitEvent event) {
        if (!this.isSilentJoinQuit(event.getPlayer(), "quit") && !this.isVanishHide(event.getPlayer())) {
            this.sendJoinQuitMessage(event.getPlayer(), event.getQuitMessage(), MessageType.DefaultTypes.LEAVE);
        }
    }

    public boolean isSilentJoinQuit(Player player, String type) {
        return this.isSilentJoinQuit((IUser)this.jda.getPlugin().getEss().getUser(player), type);
    }

    public boolean isSilentJoinQuit(IUser user, String type) {
        return this.jda.getPlugin().getEss().getSettings().allowSilentJoinQuit() && user.isAuthorized("essentials.silent" + type);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVanishStatusChange(VanishStatusChangeEvent event) {
        if (!this.jda.getSettings().isVanishFakeJoinLeave() || event.getAffected().isLeavingHidden()) {
            return;
        }
        if (event.getValue()) {
            this.sendJoinQuitMessage(event.getAffected().getBase(), ChatColor.YELLOW + event.getAffected().getName() + " left the game", MessageType.DefaultTypes.LEAVE);
            return;
        }
        this.sendJoinQuitMessage(event.getAffected().getBase(), ChatColor.YELLOW + event.getAffected().getName() + " joined the game", MessageType.DefaultTypes.JOIN);
    }

    public void sendJoinQuitMessage(Player player, String message, MessageType type) {
        MessageFormat format;
        int onlineCount = this.jda.getPlugin().getEss().getOnlinePlayers().size();
        switch (type.getKey()) {
            case "join": {
                format = this.jda.getSettings().getJoinFormat(player);
                break;
            }
            case "first-join": {
                format = this.jda.getSettings().getFirstJoinFormat(player);
                break;
            }
            default: {
                format = this.jda.getSettings().getQuitFormat(player);
                --onlineCount;
            }
        }
        this.sendDiscordMessage(type, MessageUtil.formatMessage(format, MessageUtil.sanitizeDiscordMarkdown(player.getName()), MessageUtil.sanitizeDiscordMarkdown(player.getDisplayName()), MessageUtil.sanitizeDiscordMarkdown(message), onlineCount, this.jda.getPlugin().getEss().getUsers().getUserCount()), player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(PlayerDeathEvent event) {
        if (this.isVanishHide(event.getEntity())) {
            return;
        }
        Object showDeathMessages = VersionUtil.getServerBukkitVersion().isHigherThan(VersionUtil.v1_12_2_R01) ? (Boolean)event.getEntity().getWorld().getGameRuleValue(GameRule.SHOW_DEATH_MESSAGES) : (!event.getEntity().getWorld().isGameRule("showDeathMessages") ? null : Boolean.valueOf(event.getEntity().getWorld().getGameRuleValue("showDeathMessages").equals("true")));
        if (showDeathMessages != null && !((Boolean)showDeathMessages).booleanValue() || event.getDeathMessage() == null || event.getDeathMessage().trim().isEmpty()) {
            return;
        }
        this.sendDiscordMessage(MessageType.DefaultTypes.DEATH, MessageUtil.formatMessage(this.jda.getSettings().getDeathFormat(event.getEntity()), MessageUtil.sanitizeDiscordMarkdown(event.getEntity().getName()), MessageUtil.sanitizeDiscordMarkdown(event.getEntity().getDisplayName()), MessageUtil.sanitizeDiscordMarkdown(event.getDeathMessage())), event.getEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAfk(AfkStatusChangeEvent event) {
        if (this.isVanishHide(event.getAffected())) {
            return;
        }
        MessageFormat format = event.getValue() ? this.jda.getSettings().getAfkFormat(event.getAffected().getBase()) : this.jda.getSettings().getUnAfkFormat(event.getAffected().getBase());
        this.sendDiscordMessage(MessageType.DefaultTypes.AFK, MessageUtil.formatMessage(format, MessageUtil.sanitizeDiscordMarkdown(event.getAffected().getName()), MessageUtil.sanitizeDiscordMarkdown(event.getAffected().getDisplayName())), event.getAffected().getBase());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onAdvancement(AbstractAchievementEvent event) {
        if (this.isVanishHide(event.getPlayer())) {
            return;
        }
        this.sendDiscordMessage(MessageType.DefaultTypes.ADVANCEMENT, MessageUtil.formatMessage(this.jda.getSettings().getAdvancementFormat(event.getPlayer()), MessageUtil.sanitizeDiscordMarkdown(event.getPlayer().getName()), MessageUtil.sanitizeDiscordMarkdown(event.getPlayer().getDisplayName()), event.getName()), event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onAction(UserActionEvent event) {
        if (this.isVanishHide(event.getUser())) {
            return;
        }
        this.sendDiscordMessage(MessageType.DefaultTypes.ACTION, MessageUtil.formatMessage(this.jda.getSettings().getActionFormat(event.getUser().getBase()), MessageUtil.sanitizeDiscordMarkdown(event.getUser().getName()), MessageUtil.sanitizeDiscordMarkdown(event.getUser().getDisplayName()), event.getMessage()), event.getUser().getBase());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onKick(PlayerKickEvent event) {
        if (this.isVanishHide(event.getPlayer())) {
            return;
        }
        this.sendDiscordMessage(MessageType.DefaultTypes.KICK, MessageUtil.formatMessage(this.jda.getSettings().getKickFormat(), MessageUtil.sanitizeDiscordMarkdown(event.getPlayer().getName()), MessageUtil.sanitizeDiscordMarkdown(event.getPlayer().getDisplayName()), MessageUtil.sanitizeDiscordMarkdown(event.getReason())));
    }

    private boolean isVanishHide(Player player) {
        return this.isVanishHide((IUser)this.jda.getPlugin().getEss().getUser(player));
    }

    private boolean isVanishHide(IUser user) {
        return this.jda.getSettings().isVanishHideMessages() && (user.isHidden() || user.isLeavingHidden());
    }

    private void sendDiscordMessage(MessageType messageType, String message) {
        this.sendDiscordMessage(messageType, message, null);
    }

    private void sendDiscordMessage(MessageType messageType, String message, Player player) {
        String avatarUrl = null;
        String name = null;
        UUID uuid = null;
        if (player != null) {
            if (this.jda.getSettings().isShowAvatar()) {
                avatarUrl = DiscordUtil.getAvatarUrl(this.jda, player);
            }
            name = MessageUtil.formatMessage(this.jda.getSettings().getMcToDiscordNameFormat(player), player.getName(), player.getDisplayName(), this.jda.getPlugin().getEss().getSettings().getWorldAlias(player.getWorld().getName()), FormatUtil.stripEssentialsFormat((String)this.jda.getPlugin().getEss().getPermissionsHandler().getPrefix(player)), FormatUtil.stripEssentialsFormat((String)this.jda.getPlugin().getEss().getPermissionsHandler().getSuffix(player)), this.jda.getGuild().getMember(this.jda.getJda().getSelfUser()).getEffectiveName());
            uuid = player.getUniqueId();
        }
        DiscordUtil.dispatchDiscordMessage(this.jda, messageType, message, false, avatarUrl, name, uuid);
    }
}

