/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.interactions.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.messaging.IMessageRecipient;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.concurrent.atomic.AtomicReference;
import net.essentialsx.api.v2.services.discord.InteractionCommandArgument;
import net.essentialsx.api.v2.services.discord.InteractionCommandArgumentType;
import net.essentialsx.api.v2.services.discord.InteractionEvent;
import net.essentialsx.discord.JDADiscordService;
import net.essentialsx.discord.interactions.InteractionCommandImpl;
import net.essentialsx.discord.util.DiscordMessageRecipient;
import net.essentialsx.discord.util.MessageUtil;
import org.bukkit.Bukkit;

public class MessageCommand
extends InteractionCommandImpl {
    public MessageCommand(JDADiscordService jda) {
        super(jda, "msg", I18n.tl((String)"discordCommandMessageDescription", (Object[])new Object[0]));
        this.addArgument(new InteractionCommandArgument("username", I18n.tl((String)"discordCommandMessageArgumentUsername", (Object[])new Object[0]), InteractionCommandArgumentType.STRING, true));
        this.addArgument(new InteractionCommandArgument("message", I18n.tl((String)"discordCommandMessageArgumentMessage", (Object[])new Object[0]), InteractionCommandArgumentType.STRING, true));
    }

    @Override
    public void onCommand(InteractionEvent event) {
        User user;
        boolean getHidden = event.getMember().hasRoles(this.getAdminSnowflakes());
        try {
            user = this.jda.getPlugin().getEss().matchUser(Bukkit.getServer(), null, event.getStringArgument("username"), Boolean.valueOf(getHidden), false);
        }
        catch (PlayerNotFoundException e) {
            event.reply(I18n.tl((String)"errorWithMessage", (Object[])new Object[]{e.getMessage()}));
            return;
        }
        if (!getHidden && user.isIgnoreMsg()) {
            event.reply(I18n.tl((String)"msgIgnore", (Object[])new Object[]{MessageUtil.sanitizeDiscordMarkdown(user.getDisplayName())}));
            return;
        }
        if (user.isAfk()) {
            if (user.getAfkMessage() != null) {
                event.reply(I18n.tl((String)"userAFKWithMessage", (Object[])new Object[]{MessageUtil.sanitizeDiscordMarkdown(user.getDisplayName()), MessageUtil.sanitizeDiscordMarkdown(user.getAfkMessage())}));
            } else {
                event.reply(I18n.tl((String)"userAFK", (Object[])new Object[]{MessageUtil.sanitizeDiscordMarkdown(user.getDisplayName())}));
            }
        }
        String message = event.getMember().hasRoles(this.jda.getSettings().getPermittedFormattingRoles()) ? FormatUtil.replaceFormat((String)event.getStringArgument("message")) : FormatUtil.stripFormat((String)event.getStringArgument("message"));
        event.reply(I18n.tl((String)"msgFormat", (Object[])new Object[]{I18n.tl((String)"meSender", (Object[])new Object[0]), MessageUtil.sanitizeDiscordMarkdown(user.getDisplayName()), MessageUtil.sanitizeDiscordMarkdown(message)}));
        user.sendMessage(I18n.tl((String)"msgFormat", (Object[])new Object[]{event.getMember().getTag(), I18n.tl((String)"meRecipient", (Object[])new Object[0]), message}));
        AtomicReference<DiscordMessageRecipient> ref = new AtomicReference<DiscordMessageRecipient>(new DiscordMessageRecipient(event.getMember()));
        this.jda.getPlugin().getEss().runTaskLaterAsynchronously(() -> ref.set(null), 6000L);
        user.setReplyRecipient((IMessageRecipient)ref.get());
    }
}

