/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.interactions.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.PlayerList;
import java.util.ArrayList;
import java.util.Map;
import net.essentialsx.api.v2.services.discord.InteractionCommandArgument;
import net.essentialsx.api.v2.services.discord.InteractionCommandArgumentType;
import net.essentialsx.api.v2.services.discord.InteractionEvent;
import net.essentialsx.discord.JDADiscordService;
import net.essentialsx.discord.interactions.InteractionCommandImpl;
import net.essentialsx.discord.util.MessageUtil;

public class ListCommand
extends InteractionCommandImpl {
    public ListCommand(JDADiscordService jda) {
        super(jda, "list", I18n.tl((String)"discordCommandListDescription", (Object[])new Object[0]));
        this.addArgument(new InteractionCommandArgument("group", I18n.tl((String)"discordCommandListArgumentGroup", (Object[])new Object[0]), InteractionCommandArgumentType.STRING, false));
    }

    @Override
    public void onCommand(InteractionEvent event) {
        boolean showHidden = event.getMember().hasRoles(this.getAdminSnowflakes());
        ArrayList<String> output = new ArrayList<String>();
        IEssentials ess = this.jda.getPlugin().getEss();
        output.add(PlayerList.listSummary((IEssentials)ess, null, (boolean)showHidden));
        Map playerList = PlayerList.getPlayerLists((IEssentials)ess, null, (boolean)showHidden);
        String group = event.getStringArgument("group");
        if (group != null) {
            try {
                output.add(PlayerList.listGroupUsers((IEssentials)ess, (Map)playerList, (String)group));
            }
            catch (Exception e) {
                output.add(I18n.tl((String)"errorWithMessage", (Object[])new Object[]{e.getMessage()}));
            }
        } else {
            output.addAll(PlayerList.prepareGroupedList((IEssentials)ess, (String)this.getName(), (Map)playerList));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String str : output) {
            stringBuilder.append(str).append("\n");
        }
        event.reply(MessageUtil.sanitizeDiscordMarkdown(stringBuilder.substring(0, stringBuilder.length() - 2)));
    }
}

