/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord.interactions;

import java.util.ArrayList;
import java.util.List;
import net.essentialsx.api.v2.services.discord.InteractionCommand;
import net.essentialsx.api.v2.services.discord.InteractionCommandArgument;
import net.essentialsx.discord.JDADiscordService;

public abstract class InteractionCommandImpl
implements InteractionCommand {
    protected final JDADiscordService jda;
    private final String name;
    private final String description;
    private final List<InteractionCommandArgument> arguments = new ArrayList<InteractionCommandArgument>();

    public InteractionCommandImpl(JDADiscordService jda, String name, String description) {
        this.jda = jda;
        this.name = name;
        this.description = description;
    }

    @Override
    public final boolean isDisabled() {
        return !this.jda.getSettings().isCommandEnabled(this.name);
    }

    @Override
    public final boolean isEphemeral() {
        return this.jda.getSettings().isCommandEphemeral(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<InteractionCommandArgument> getArguments() {
        return this.arguments;
    }

    public List<String> getAdminSnowflakes() {
        return this.jda.getSettings().getCommandAdminSnowflakes(this.name);
    }

    public void addArgument(InteractionCommandArgument argument) {
        this.arguments.add(argument);
    }
}

