/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentialsModule;
import com.earth2me.essentials.User;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import net.ess3.nms.refl.providers.AchievementListenerProvider;
import net.ess3.nms.refl.providers.AdvancementListenerProvider;
import net.ess3.provider.providers.PaperAdvancementListenerProvider;
import net.essentialsx.api.v2.ChatType;
import net.essentialsx.api.v2.events.discord.DiscordMessageEvent;
import net.essentialsx.api.v2.services.discord.DiscordService;
import net.essentialsx.api.v2.services.discord.InteractionController;
import net.essentialsx.api.v2.services.discord.InteractionException;
import net.essentialsx.api.v2.services.discord.InteractionMember;
import net.essentialsx.api.v2.services.discord.InteractionRole;
import net.essentialsx.api.v2.services.discord.MessageType;
import net.essentialsx.api.v2.services.discord.Unsafe;
import net.essentialsx.dep.club.minnced.discord.webhook.WebhookClientBuilder;
import net.essentialsx.dep.club.minnced.discord.webhook.send.WebhookMessage;
import net.essentialsx.dep.club.minnced.discord.webhook.send.WebhookMessageBuilder;
import net.essentialsx.dep.net.dv8tion.jda.api.JDA;
import net.essentialsx.dep.net.dv8tion.jda.api.JDABuilder;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Guild;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Member;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Role;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Webhook;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.emoji.RichCustomEmoji;
import net.essentialsx.dep.net.dv8tion.jda.api.events.session.ShutdownEvent;
import net.essentialsx.dep.net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.GatewayIntent;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.essentialsx.dep.net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.essentialsx.discord.DiscordSettings;
import net.essentialsx.discord.EssentialsDiscord;
import net.essentialsx.discord.interactions.InteractionControllerImpl;
import net.essentialsx.discord.interactions.InteractionMemberImpl;
import net.essentialsx.discord.interactions.InteractionRoleImpl;
import net.essentialsx.discord.interactions.commands.ExecuteCommand;
import net.essentialsx.discord.interactions.commands.ListCommand;
import net.essentialsx.discord.interactions.commands.MessageCommand;
import net.essentialsx.discord.listeners.BukkitChatListener;
import net.essentialsx.discord.listeners.BukkitListener;
import net.essentialsx.discord.listeners.DiscordCommandDispatcher;
import net.essentialsx.discord.listeners.DiscordListener;
import net.essentialsx.discord.listeners.EssentialsChatListener;
import net.essentialsx.discord.util.ConsoleInjector;
import net.essentialsx.discord.util.DiscordUtil;
import net.essentialsx.discord.util.MessageUtil;
import net.essentialsx.discord.util.WrappedWebhookClient;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.NotNull;

public class JDADiscordService
implements DiscordService,
IEssentialsModule {
    private static final Logger logger = EssentialsDiscord.getWrappedLogger();
    private final EssentialsDiscord plugin;
    private final Unsafe unsafe = this::getJda;
    private JDA jda;
    private Guild guild;
    private TextChannel primaryChannel;
    private WrappedWebhookClient consoleWebhook;
    private String lastConsoleId;
    private final Map<String, MessageType> registeredTypes = new HashMap<String, MessageType>();
    private final Map<MessageType, String> typeToChannelId = new HashMap<MessageType, String>();
    private final Map<String, WrappedWebhookClient> channelIdToWebhook = new HashMap<String, WrappedWebhookClient>();
    private ConsoleInjector injector;
    private DiscordCommandDispatcher commandDispatcher;
    private InteractionControllerImpl interactionController;
    private Listener chatListener;
    private boolean invalidStartup = false;

    public JDADiscordService(EssentialsDiscord plugin) {
        this.plugin = plugin;
        for (MessageType type : MessageType.DefaultTypes.values()) {
            this.registerMessageType((Plugin)plugin, type);
        }
    }

    public TextChannel getChannel(String key, boolean primaryFallback) {
        if (NumberUtil.isLong((String)key)) {
            return this.getDefinedChannel(key, primaryFallback);
        }
        return this.getDefinedChannel(this.getSettings().getMessageChannel(key), primaryFallback);
    }

    public TextChannel getDefinedChannel(String key, boolean primaryFallback) {
        TextChannel channel;
        long resolvedId = this.getSettings().getChannelId(key);
        if (this.isDebug()) {
            logger.log(Level.INFO, "Channel definition " + key + " resolved as " + resolvedId);
        }
        if ((channel = this.guild.getTextChannelById(resolvedId)) == null && primaryFallback) {
            if (this.isDebug()) {
                logger.log(Level.WARNING, "Resolved channel id " + resolvedId + " was not found! Falling back to primary channel.");
            }
            channel = this.primaryChannel;
        }
        return channel;
    }

    public WebhookMessage getWebhookMessage(String message) {
        return this.getWebhookMessage(message, this.jda.getSelfUser().getAvatarUrl(), this.getSettings().getConsoleWebhookName(), false);
    }

    public WebhookMessage getWebhookMessage(String message, String avatarUrl, String name, boolean groupMentions) {
        return new WebhookMessageBuilder().setAvatarUrl(avatarUrl).setAllowedMentions(groupMentions ? DiscordUtil.ALL_MENTIONS_WEBHOOK : DiscordUtil.NO_GROUP_MENTIONS_WEBHOOK).setUsername(name).setContent(message).build();
    }

    public void sendMessage(DiscordMessageEvent event, String message, boolean groupMentions) {
        WrappedWebhookClient client;
        TextChannel channel = this.getChannel(event.getType().getKey(), true);
        String strippedContent = FormatUtil.stripFormat((String)message);
        String webhookChannelId = this.typeToChannelId.get(event.getType());
        if (webhookChannelId != null && (client = this.channelIdToWebhook.get(webhookChannelId)) != null) {
            String avatarUrl = event.getAvatarUrl() != null ? event.getAvatarUrl() : this.jda.getSelfUser().getAvatarUrl();
            String name = event.getName() != null ? event.getName() : this.guild.getSelfMember().getEffectiveName();
            client.send(this.getWebhookMessage(strippedContent, avatarUrl, name, groupMentions));
            return;
        }
        if (!channel.canTalk()) {
            logger.warning(I18n.tl((String)"discordNoSendPermission", (Object[])new Object[]{channel.getName()}));
            return;
        }
        ((MessageCreateAction)channel.sendMessage(strippedContent).setAllowedMentions(groupMentions ? null : DiscordUtil.NO_GROUP_MENTIONS)).queue();
    }

    public void startup() throws LoginException, InterruptedException {
        this.shutdown();
        this.invalidStartup = true;
        logger.log(Level.INFO, I18n.tl((String)"discordLoggingIn", (Object[])new Object[0]));
        if (this.plugin.getSettings().getBotToken().replace("INSERT-TOKEN-HERE", "").trim().isEmpty()) {
            throw new IllegalArgumentException(I18n.tl((String)"discordErrorNoToken", (Object[])new Object[0]));
        }
        this.jda = JDABuilder.createDefault(this.plugin.getSettings().getBotToken()).addEventListeners(new DiscordListener(this)).enableIntents(GatewayIntent.MESSAGE_CONTENT, new GatewayIntent[0]).enableCache(CacheFlag.EMOJI, new CacheFlag[0]).disableCache(CacheFlag.MEMBER_OVERRIDES, CacheFlag.VOICE_STATE).setContextEnabled(false).build().awaitReady();
        this.invalidStartup = false;
        this.updatePresence();
        logger.log(Level.INFO, I18n.tl((String)"discordLoggingInDone", (Object[])new Object[]{this.jda.getSelfUser().getAsTag()}));
        if (this.jda.getGuilds().isEmpty()) {
            this.invalidStartup = true;
            throw new IllegalArgumentException(I18n.tl((String)"discordErrorNoGuildSize", (Object[])new Object[0]));
        }
        this.guild = this.jda.getGuildById(this.plugin.getSettings().getGuildId());
        if (this.guild == null) {
            this.invalidStartup = true;
            throw new IllegalArgumentException(I18n.tl((String)"discordErrorNoGuild", (Object[])new Object[0]));
        }
        this.interactionController = new InteractionControllerImpl(this);
        try {
            this.interactionController.registerCommand(new ExecuteCommand(this));
        }
        catch (InteractionException interactionException) {
            // empty catch block
        }
        try {
            this.interactionController.registerCommand(new MessageCommand(this));
        }
        catch (InteractionException interactionException) {
            // empty catch block
        }
        try {
            this.interactionController.registerCommand(new ListCommand(this));
        }
        catch (InteractionException interactionException) {
            // empty catch block
        }
        this.guild.retrieveEmojis().queue();
        this.updatePrimaryChannel();
        this.updateConsoleRelay();
        this.updateTypesRelay();
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitListener(this), (Plugin)this.plugin);
        this.updateListener();
        try {
            if (VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_12_0_R01)) {
                try {
                    Class.forName("io.papermc.paper.advancement.AdvancementDisplay");
                    Bukkit.getPluginManager().registerEvents((Listener)new PaperAdvancementListenerProvider(), (Plugin)this.plugin);
                }
                catch (ClassNotFoundException e) {
                    Bukkit.getPluginManager().registerEvents((Listener)new AdvancementListenerProvider(), (Plugin)this.plugin);
                }
            } else {
                Bukkit.getPluginManager().registerEvents((Listener)new AchievementListenerProvider(), (Plugin)this.plugin);
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Error while loading the achievement/advancement listener. You will not receive achievement/advancement notifications on Discord.", e);
        }
        this.getPlugin().getEss().scheduleSyncDelayedTask(() -> DiscordUtil.dispatchDiscordMessage(this, MessageType.DefaultTypes.SERVER_START, this.getSettings().getStartMessage(), true, null, null, null));
        Bukkit.getServicesManager().register(DiscordService.class, (Object)this, (Plugin)this.plugin, ServicePriority.Normal);
    }

    @Override
    public boolean isRegistered(String key) {
        return this.registeredTypes.containsKey(key);
    }

    @Override
    public void registerMessageType(Plugin plugin, MessageType type) {
        if (!type.getKey().matches("^[a-z][a-z0-9-]*$")) {
            throw new IllegalArgumentException("MessageType key must match \"^[a-z][a-z0-9-]*$\"");
        }
        if (this.registeredTypes.containsKey(type.getKey())) {
            throw new IllegalArgumentException("A MessageType with that key is already registered!");
        }
        this.registeredTypes.put(type.getKey(), type);
    }

    @Override
    public void sendMessage(MessageType type, String message, boolean allowGroupMentions) {
        if (!this.registeredTypes.containsKey(type.getKey()) && !NumberUtil.isLong((String)type.getKey())) {
            logger.warning("Sending message to channel \"" + type.getKey() + "\" which is an unregistered type! If you are a plugin author, you should be registering your MessageType before using them.");
        }
        DiscordMessageEvent event = new DiscordMessageEvent(type, FormatUtil.stripFormat((String)message), allowGroupMentions);
        if (Bukkit.getServer().isPrimaryThread()) {
            Bukkit.getPluginManager().callEvent((Event)event);
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)event));
        }
    }

    @Override
    public void sendChatMessage(Player player, String chatMessage) {
        this.sendChatMessage(ChatType.UNKNOWN, player, chatMessage);
    }

    @Override
    public void sendChatMessage(ChatType chatType, Player player, String chatMessage) {
        User user = this.getPlugin().getEss().getUser(player);
        String formattedMessage = MessageUtil.formatMessage(this.getSettings().getMcToDiscordFormat(player, chatType), MessageUtil.sanitizeDiscordMarkdown(player.getName()), MessageUtil.sanitizeDiscordMarkdown(player.getDisplayName()), user.isAuthorized("essentials.discord.markdown") ? chatMessage : MessageUtil.sanitizeDiscordMarkdown(chatMessage), MessageUtil.sanitizeDiscordMarkdown(this.getPlugin().getEss().getSettings().getWorldAlias(player.getWorld().getName())), MessageUtil.sanitizeDiscordMarkdown(FormatUtil.stripEssentialsFormat((String)this.getPlugin().getEss().getPermissionsHandler().getPrefix(player))), MessageUtil.sanitizeDiscordMarkdown(FormatUtil.stripEssentialsFormat((String)this.getPlugin().getEss().getPermissionsHandler().getSuffix(player))));
        String avatarUrl = DiscordUtil.getAvatarUrl(this, player);
        String formattedName = MessageUtil.formatMessage(this.getSettings().getMcToDiscordNameFormat(player), player.getName(), player.getDisplayName(), this.getPlugin().getEss().getSettings().getWorldAlias(player.getWorld().getName()), FormatUtil.stripEssentialsFormat((String)this.getPlugin().getEss().getPermissionsHandler().getPrefix(player)), FormatUtil.stripEssentialsFormat((String)this.getPlugin().getEss().getPermissionsHandler().getSuffix(player)), this.guild.getMember(this.jda.getSelfUser()).getEffectiveName());
        DiscordUtil.dispatchDiscordMessage(this, this.chatTypeToMessageType(chatType), formattedMessage, user.isAuthorized("essentials.discord.ping"), avatarUrl, formattedName, player.getUniqueId());
    }

    private MessageType chatTypeToMessageType(ChatType chatType) {
        switch (chatType) {
            case SHOUT: {
                return MessageType.DefaultTypes.SHOUT;
            }
            case QUESTION: {
                return MessageType.DefaultTypes.QUESTION;
            }
            case LOCAL: {
                return MessageType.DefaultTypes.LOCAL;
            }
        }
        return MessageType.DefaultTypes.CHAT;
    }

    @Override
    public InteractionController getInteractionController() {
        return this.interactionController;
    }

    public void updatePrimaryChannel() {
        TextChannel channel = this.guild.getTextChannelById(this.plugin.getSettings().getPrimaryChannelId());
        if (channel == null) {
            if (!(this.guild.getDefaultChannel() instanceof TextChannel)) {
                throw new RuntimeException(I18n.tl((String)"discordErrorNoPerms", (Object[])new Object[0]));
            }
            channel = (TextChannel)((Object)this.guild.getDefaultChannel());
            logger.warning(I18n.tl((String)"discordErrorNoPrimary", (Object[])new Object[]{channel.getName()}));
        }
        if (!channel.canTalk()) {
            throw new RuntimeException(I18n.tl((String)"discordErrorNoPrimaryPerms", (Object[])new Object[]{channel.getName()}));
        }
        this.primaryChannel = channel;
    }

    public String parseMessageEmotes(String message) {
        for (RichCustomEmoji emote : this.guild.getEmojiCache()) {
            message = message.replaceAll(":" + Pattern.quote(emote.getName()) + ":", emote.getAsMention());
        }
        return message;
    }

    public void updateListener() {
        if (this.chatListener != null) {
            HandlerList.unregisterAll((Listener)this.chatListener);
            this.chatListener = null;
        }
        this.chatListener = this.getSettings().isUseEssentialsEvents() && this.plugin.isEssentialsChat() ? new EssentialsChatListener(this) : new BukkitChatListener(this);
        Bukkit.getPluginManager().registerEvents(this.chatListener, (Plugin)this.plugin);
    }

    public void updatePresence() {
        this.jda.getPresence().setPresence(this.plugin.getSettings().getStatus(), this.plugin.getSettings().getStatusActivity());
    }

    public void updateTypesRelay() {
        if (!(this.getSettings().isShowAvatar() || this.getSettings().isShowName() || this.getSettings().isShowDisplayName())) {
            for (WrappedWebhookClient webhook : this.channelIdToWebhook.values()) {
                webhook.close();
            }
            this.typeToChannelId.clear();
            this.channelIdToWebhook.clear();
            return;
        }
        for (MessageType type : MessageType.DefaultTypes.values()) {
            TextChannel channel;
            if (!type.isPlayer() || (channel = this.getChannel(type.getKey(), true)).getId().equals(this.typeToChannelId.get(type))) continue;
            Webhook webhook = DiscordUtil.getOrCreateWebhook(channel, "EssX Advanced Relay").join();
            if (webhook == null) {
                WrappedWebhookClient current = this.channelIdToWebhook.get(channel.getId());
                if (current != null) {
                    current.close();
                }
                this.channelIdToWebhook.remove(channel.getId()).close();
                continue;
            }
            this.typeToChannelId.put(type, channel.getId());
            this.channelIdToWebhook.put(channel.getId(), DiscordUtil.getWebhookClient(webhook.getIdLong(), webhook.getToken(), this.jda.getHttpClient()));
        }
    }

    public void updateConsoleRelay() {
        String webhookToken;
        long webhookId;
        String consoleDef = this.getSettings().getConsoleChannelDef();
        Matcher matcher = WebhookClientBuilder.WEBHOOK_PATTERN.matcher(consoleDef);
        if (matcher.matches()) {
            webhookId = Long.parseUnsignedLong(matcher.group(1));
            webhookToken = matcher.group(2);
            if (this.commandDispatcher != null) {
                this.jda.removeEventListener(this.commandDispatcher);
                this.commandDispatcher = null;
            }
        } else {
            TextChannel channel = this.getChannel(consoleDef, false);
            if (channel != null) {
                if (this.getSettings().isConsoleCommandRelay()) {
                    if (this.commandDispatcher == null) {
                        this.commandDispatcher = new DiscordCommandDispatcher(this);
                        this.jda.addEventListener(this.commandDispatcher);
                    }
                    this.commandDispatcher.setChannelId(channel.getId());
                } else if (this.commandDispatcher != null) {
                    this.jda.removeEventListener(this.commandDispatcher);
                    this.commandDispatcher = null;
                }
                if (channel.getId().equals(this.lastConsoleId)) {
                    return;
                }
                Webhook webhook = DiscordUtil.getOrCreateWebhook(channel, "EssX Console Relay").join();
                if (webhook == null) {
                    logger.info(I18n.tl((String)"discordErrorLoggerNoPerms", (Object[])new Object[0]));
                    return;
                }
                webhookId = webhook.getIdLong();
                webhookToken = webhook.getToken();
                this.lastConsoleId = channel.getId();
            } else {
                if (!this.getSettings().getConsoleChannelDef().equals("none") && !this.getSettings().getConsoleChannelDef().startsWith("0")) {
                    logger.info(I18n.tl((String)"discordErrorLoggerInvalidChannel", (Object[])new Object[0]));
                    this.shutdownConsoleRelay(true);
                    return;
                }
                this.shutdownConsoleRelay(true);
                return;
            }
        }
        this.shutdownConsoleRelay(false);
        this.consoleWebhook = DiscordUtil.getWebhookClient(webhookId, webhookToken, this.jda.getHttpClient());
        if (this.injector == null || this.injector.isRemoved()) {
            this.injector = new ConsoleInjector(this);
            this.injector.start();
        }
    }

    private void shutdownConsoleRelay(boolean closeInjector) {
        if (this.consoleWebhook != null && !this.consoleWebhook.isShutdown()) {
            this.consoleWebhook.close();
        }
        this.consoleWebhook = null;
        if (closeInjector) {
            if (this.injector != null) {
                this.injector.remove();
                this.injector = null;
            }
            if (this.commandDispatcher != null) {
                this.jda.removeEventListener(this.commandDispatcher);
                this.commandDispatcher = null;
            }
        }
    }

    public void shutdown() {
        if (this.interactionController != null) {
            this.interactionController.shutdown();
        }
        if (this.jda != null) {
            if (!this.invalidStartup) {
                this.sendMessage(MessageType.DefaultTypes.SERVER_STOP, this.getSettings().getStopMessage(), true);
                DiscordUtil.dispatchDiscordMessage(this, MessageType.DefaultTypes.SERVER_STOP, this.getSettings().getStopMessage(), true, null, null, null);
            }
            this.shutdownConsoleRelay(true);
            for (WrappedWebhookClient webhook : this.channelIdToWebhook.values()) {
                webhook.close();
            }
            for (Object obj : this.jda.getRegisteredListeners()) {
                this.jda.removeEventListener(obj);
            }
            HandlerList.unregisterAll((Plugin)this.plugin);
            final CompletableFuture future = new CompletableFuture();
            this.jda.addEventListener(new ListenerAdapter(){

                @Override
                public void onShutdown(@NotNull ShutdownEvent event) {
                    future.complete(null);
                }
            });
            this.jda.shutdown();
            try {
                future.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.log(Level.WARNING, "JDA took longer than expected to shutdown, this may have caused some problems.", e);
            }
            finally {
                this.jda = null;
            }
        }
    }

    @Override
    public CompletableFuture<InteractionMember> getMemberById(String id) {
        CompletableFuture<InteractionMember> future = new CompletableFuture<InteractionMember>();
        this.getGuild().retrieveMemberById(id).queue(member -> {
            if (member != null) {
                future.complete(new InteractionMemberImpl((Member)member));
                return;
            }
            future.complete(null);
        }, fail -> future.complete(null));
        return future;
    }

    @Override
    public InteractionRole getRole(String id) {
        Role role = this.getGuild().getRoleById(id);
        return role == null ? null : new InteractionRoleImpl(role);
    }

    @Override
    public CompletableFuture<Void> modifyMemberRoles(InteractionMember member, Collection<InteractionRole> addRoles, Collection<InteractionRole> removeRoles) {
        if ((addRoles == null || addRoles.isEmpty()) && (removeRoles == null || removeRoles.isEmpty())) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<Role> add = new ArrayList<Role>();
        ArrayList<Role> remove = new ArrayList<Role>();
        if (addRoles != null) {
            for (InteractionRole role : addRoles) {
                add.add(((InteractionRoleImpl)role).getJdaObject());
            }
        }
        if (removeRoles != null) {
            for (InteractionRole role : removeRoles) {
                remove.add(((InteractionRoleImpl)role).getJdaObject());
            }
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.guild.modifyMemberRoles(((InteractionMemberImpl)member).getJdaObject(), add, remove).queue(future::complete);
        return future;
    }

    @Override
    public String getInviteUrl() {
        return this.getSettings().getDiscordUrl();
    }

    public JDA getJda() {
        return this.jda;
    }

    @Override
    public Unsafe getUnsafe() {
        return this.unsafe;
    }

    public Guild getGuild() {
        return this.guild;
    }

    public EssentialsDiscord getPlugin() {
        return this.plugin;
    }

    public DiscordSettings getSettings() {
        return this.plugin.getSettings();
    }

    public WrappedWebhookClient getConsoleWebhook() {
        return this.consoleWebhook;
    }

    public boolean isInvalidStartup() {
        return this.invalidStartup;
    }

    public boolean isDebug() {
        return this.plugin.getEss().getSettings().isDebug();
    }
}

