/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discord;

import com.earth2me.essentials.EssentialsLogger;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.IEssentialsModule;
import com.earth2me.essentials.metrics.MetricsWrapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.essentialsx.discord.DiscordSettings;
import net.essentialsx.discord.JDADiscordService;
import net.essentialsx.discord.interactions.InteractionControllerImpl;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EssentialsDiscord
extends JavaPlugin
implements IEssentialsModule {
    private transient IEssentials ess;
    private transient MetricsWrapper metrics = null;
    private JDADiscordService jda;
    private DiscordSettings settings;
    private boolean isPAPI = false;
    private boolean isEssentialsChat = false;

    public void onEnable() {
        EssentialsLogger.updatePluginLogger((Plugin)this);
        this.ess = (IEssentials)this.getServer().getPluginManager().getPlugin("Essentials");
        if (this.ess == null || !this.ess.isEnabled()) {
            this.setEnabled(false);
            return;
        }
        if (!this.getDescription().getVersion().equals(this.ess.getDescription().getVersion())) {
            this.getLogger().log(Level.WARNING, I18n.tl((String)"versionMismatchAll", (Object[])new Object[0]));
        }
        String[] javaVersion = System.getProperty("java.version").split("\\.");
        if (Runtime.getRuntime().availableProcessors() <= 1 && javaVersion[0].startsWith("17") && (javaVersion.length < 2 || javaVersion[1].equals("0") && javaVersion[2].startsWith("1"))) {
            this.getLogger().log(Level.INFO, "Essentials is mitigating JDK-8274349");
            System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "1");
        }
        this.isPAPI = this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
        this.isEssentialsChat = this.getServer().getPluginManager().getPlugin("EssentialsChat") != null;
        this.settings = new DiscordSettings(this);
        this.ess.addReloadListener((IConf)this.settings);
        if (this.metrics == null) {
            this.metrics = new MetricsWrapper((JavaPlugin)this, 9824, false);
        }
        if (this.jda == null) {
            this.jda = new JDADiscordService(this);
            try {
                this.jda.startup();
                this.ess.scheduleSyncDelayedTask(() -> ((InteractionControllerImpl)this.jda.getInteractionController()).processBatchRegistration());
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, I18n.tl((String)"discordErrorLogin", (Object[])new Object[]{e.getMessage()}));
                if (this.ess.getSettings().isDebug()) {
                    e.printStackTrace();
                }
                this.jda.shutdown();
            }
        }
    }

    public static Logger getWrappedLogger() {
        try {
            return EssentialsLogger.getLoggerProvider((String)"EssentialsDiscord");
        }
        catch (Throwable ignored) {
            return Logger.getLogger("EssentialsDiscord");
        }
    }

    public void onReload() {
        if (this.jda != null && !this.jda.isInvalidStartup()) {
            this.jda.updateListener();
            this.jda.updatePresence();
            this.jda.updatePrimaryChannel();
            this.jda.updateConsoleRelay();
            this.jda.updateTypesRelay();
        }
    }

    public boolean isInvalidStartup() {
        return this.jda != null && this.jda.isInvalidStartup();
    }

    public IEssentials getEss() {
        return this.ess;
    }

    public DiscordSettings getSettings() {
        return this.settings;
    }

    public boolean isPAPI() {
        return this.isPAPI;
    }

    public boolean isEssentialsChat() {
        return this.isEssentialsChat;
    }

    public void onDisable() {
        if (this.jda != null && !this.jda.isInvalidStartup()) {
            this.jda.shutdown();
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args2) {
        return this.ess.onCommandEssentials(sender, command, label, args2, EssentialsDiscord.class.getClassLoader(), "net.essentialsx.discord.commands.Command", "essentials.", (IEssentialsModule)this.jda);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args2) {
        return this.ess.onTabCompleteEssentials(sender, command, alias, args2, EssentialsDiscord.class.getClassLoader(), "net.essentialsx.discord.commands.Command", "essentials.", (IEssentialsModule)this.jda);
    }
}

