/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.dep.net.dv8tion.jda.internal.utils;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.essentialsx.dep.net.dv8tion.jda.internal.utils.IOUtil;
import net.essentialsx.dep.okhttp3.MediaType;
import net.essentialsx.dep.okhttp3.RequestBody;
import net.essentialsx.dep.okio.BufferedSink;
import net.essentialsx.dep.okio.BufferedSource;
import net.essentialsx.dep.okio.Okio;
import net.essentialsx.dep.okio.Source;

public class BufferedRequestBody
extends RequestBody {
    private final Source source;
    private final MediaType type;
    private byte[] data;

    public BufferedRequestBody(Source source2, MediaType type) {
        this.source = source2;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public BufferedRequestBody withType(@Nonnull MediaType type) {
        if (type.equals(this.type)) {
            return this;
        }
        Source source2 = this.source;
        synchronized (source2) {
            BufferedRequestBody copy = new BufferedRequestBody(this.source, type);
            copy.data = this.data;
            return copy;
        }
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(@Nonnull BufferedSink sink2) throws IOException {
        Source source2 = this.source;
        synchronized (source2) {
            if (this.data != null) {
                sink2.write(this.data);
                return;
            }
            try (BufferedSource s = Okio.buffer(this.source);){
                this.data = s.readByteArray();
                sink2.write(this.data);
            }
        }
    }

    protected void finalize() {
        IOUtil.silentClose(this.source);
    }
}

