/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.dep.net.dv8tion.jda.internal.requests.restaction.interactions;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.Request;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.Response;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.RestAction;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.Route;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.restaction.interactions.InteractionCallbackAction;
import net.essentialsx.dep.net.dv8tion.jda.internal.interactions.InteractionImpl;
import net.essentialsx.dep.net.dv8tion.jda.internal.requests.RestActionImpl;

public abstract class InteractionCallbackImpl<T>
extends RestActionImpl<T>
implements InteractionCallbackAction<T> {
    protected final InteractionImpl interaction;

    public InteractionCallbackImpl(InteractionImpl interaction) {
        super(interaction.getJDA(), Route.Interactions.CALLBACK.compile(interaction.getId(), interaction.getToken()));
        this.interaction = interaction;
    }

    @Override
    @Nonnull
    public InteractionCallbackAction<T> closeResources() {
        return this;
    }

    protected final IllegalStateException tryAck() {
        return this.interaction.ack() ? new IllegalStateException("This interaction has already been acknowledged or replied to. You can only reply or acknowledge an interaction once!") : null;
    }

    @Override
    public final void queue(Consumer<? super T> success, Consumer<? super Throwable> failure) {
        IllegalStateException exception = this.tryAck();
        if (exception != null) {
            if (failure != null) {
                failure.accept(exception);
            } else {
                RestAction.getDefaultFailure().accept(exception);
            }
            return;
        }
        super.queue(success, failure);
    }

    @Override
    @Nonnull
    public final CompletableFuture<T> submit(boolean shouldQueue) {
        IllegalStateException exception = this.tryAck();
        if (exception != null) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(exception);
            return future;
        }
        return super.submit(shouldQueue);
    }

    @Override
    protected void handleSuccess(Response response, Request<T> request) {
        this.interaction.releaseHook(true);
        super.handleSuccess(response, request);
    }

    @Override
    public void handleResponse(Response response, Request<T> request) {
        if (!response.isOk()) {
            this.interaction.releaseHook(false);
        }
        super.handleResponse(response, request);
    }
}

