/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.dep.net.dv8tion.jda.api.interactions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.essentialsx.dep.net.dv8tion.jda.api.JDA;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Guild;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.ISnowflake;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Member;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.User;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.Channel;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.ChannelType;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.essentialsx.dep.net.dv8tion.jda.api.interactions.DiscordLocale;
import net.essentialsx.dep.net.dv8tion.jda.api.interactions.InteractionType;
import net.essentialsx.dep.net.dv8tion.jda.internal.utils.Helpers;

public interface Interaction
extends ISnowflake {
    public int getTypeRaw();

    @Nonnull
    default public InteractionType getType() {
        return InteractionType.fromKey(this.getTypeRaw());
    }

    @Nonnull
    public String getToken();

    @Nullable
    public Guild getGuild();

    default public boolean isFromGuild() {
        return this.getGuild() != null;
    }

    @Nonnull
    default public ChannelType getChannelType() {
        Channel channel = this.getChannel();
        return channel != null ? channel.getType() : ChannelType.UNKNOWN;
    }

    @Nonnull
    public User getUser();

    @Nullable
    public Member getMember();

    public boolean isAcknowledged();

    @Nullable
    public Channel getChannel();

    @Nonnull
    default public GuildChannel getGuildChannel() {
        return Helpers.safeChannelCast(this.getChannel(), GuildChannel.class);
    }

    @Nonnull
    default public MessageChannel getMessageChannel() {
        return Helpers.safeChannelCast(this.getChannel(), MessageChannel.class);
    }

    @Nonnull
    public DiscordLocale getUserLocale();

    @Nonnull
    default public DiscordLocale getGuildLocale() {
        if (!this.isFromGuild()) {
            throw new IllegalStateException("This interaction did not happen in a guild");
        }
        return this.getGuild().getLocale();
    }

    @Nonnull
    public JDA getJDA();
}

