/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.attribute;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.attribute.IPermissionContainer;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.restaction.ThreadChannelAction;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.restaction.pagination.ThreadChannelPaginationAction;
import net.essentialsx.dep.net.dv8tion.jda.api.utils.MiscUtil;

public interface IThreadContainer
extends GuildChannel,
IPermissionContainer {
    public int getDefaultThreadSlowmode();

    default public List<ThreadChannel> getThreadChannels() {
        return Collections.unmodifiableList(this.getGuild().getThreadChannelCache().applyStream(stream -> stream.filter(thread -> thread.getParentChannel() == this).collect(Collectors.toList())));
    }

    @Nonnull
    @CheckReturnValue
    default public ThreadChannelAction createThreadChannel(@Nonnull String name) {
        return this.createThreadChannel(name, false);
    }

    @Nonnull
    @CheckReturnValue
    public ThreadChannelAction createThreadChannel(@Nonnull String var1, boolean var2);

    @Nonnull
    @CheckReturnValue
    public ThreadChannelAction createThreadChannel(@Nonnull String var1, long var2);

    @Nonnull
    @CheckReturnValue
    default public ThreadChannelAction createThreadChannel(@Nonnull String name, @Nonnull String messageId) {
        return this.createThreadChannel(name, MiscUtil.parseSnowflake(messageId));
    }

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPublicThreadChannels();

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPrivateThreadChannels();

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPrivateJoinedThreadChannels();
}

