/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.dep.net.dv8tion.jda.api.entities;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Guild;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.ISnowflake;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.Member;
import net.essentialsx.dep.net.dv8tion.jda.api.entities.channel.concrete.StageChannel;
import net.essentialsx.dep.net.dv8tion.jda.api.managers.StageInstanceManager;
import net.essentialsx.dep.net.dv8tion.jda.api.requests.RestAction;

public interface StageInstance
extends ISnowflake {
    @Nonnull
    public Guild getGuild();

    @Nonnull
    public StageChannel getChannel();

    @Nonnull
    public String getTopic();

    @Nonnull
    public PrivacyLevel getPrivacyLevel();

    @Nonnull
    default public List<Member> getSpeakers() {
        return Collections.unmodifiableList(this.getChannel().getMembers().stream().filter(member -> !member.getVoiceState().isSuppressed()).collect(Collectors.toList()));
    }

    @Nonnull
    default public List<Member> getAudience() {
        return Collections.unmodifiableList(this.getChannel().getMembers().stream().filter(member -> member.getVoiceState().isSuppressed()).collect(Collectors.toList()));
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> delete();

    @Nonnull
    @CheckReturnValue
    public StageInstanceManager getManager();

    public static enum PrivacyLevel {
        UNKNOWN(-1),
        PUBLIC(1),
        GUILD_ONLY(2);

        private final int key;

        private PrivacyLevel(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        @Nonnull
        public static PrivacyLevel fromKey(int key) {
            for (PrivacyLevel level : PrivacyLevel.values()) {
                if (level.key != key) continue;
                return level;
            }
            return UNKNOWN;
        }
    }
}

