/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.dep.com.vdurmont.emoji;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.essentialsx.dep.com.vdurmont.emoji.Emoji;
import net.essentialsx.dep.com.vdurmont.emoji.EmojiCategory;
import net.essentialsx.dep.com.vdurmont.emoji.EmojiLoader;
import net.essentialsx.dep.com.vdurmont.emoji.EmojiParser;
import net.essentialsx.dep.com.vdurmont.emoji.EmojiTrie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmojiManager {
    static final EmojiTrie EMOJI_TRIE;
    private static final String PATH = "/emoji-list.json";
    private static final Map<String, Emoji> EMOJIS_BY_ALIAS;
    private static final Map<String, Set<Emoji>> EMOJIS_BY_TAG;
    private static final Map<EmojiCategory, Set<Emoji>> EMOJIS_BY_CATEGORY;
    private static final List<Emoji> ALL_EMOJIS;

    private static void loadEmoji(Emoji emoji) {
        Set set = EMOJIS_BY_CATEGORY.computeIfAbsent(emoji.getCategory(), k -> new HashSet());
        set.add(emoji);
        for (String tag : emoji.getTags()) {
            set = EMOJIS_BY_TAG.computeIfAbsent(tag.toLowerCase(Locale.ROOT), k -> new HashSet());
            set.add(emoji);
        }
        for (String alias : emoji.getAliases()) {
            EMOJIS_BY_ALIAS.put(alias.toLowerCase(Locale.ROOT), emoji);
        }
    }

    private EmojiManager() {
    }

    @NotNull
    public static Set<Emoji> getForTag(@NotNull String tag) {
        if (tag == null) {
            return Collections.emptySet();
        }
        Set<Emoji> emojis = EMOJIS_BY_TAG.get(tag.toLowerCase(Locale.ROOT));
        return emojis == null ? Collections.emptySet() : emojis;
    }

    @NotNull
    public static Set<Emoji> getForCategory(@NotNull EmojiCategory category) {
        if (category == null) {
            return Collections.emptySet();
        }
        Set<Emoji> emojis = EMOJIS_BY_CATEGORY.get((Object)category);
        return emojis == null ? Collections.emptySet() : emojis;
    }

    @Nullable
    public static Emoji getForAlias(@NotNull String alias) {
        if (alias == null || alias.isEmpty()) {
            return null;
        }
        return EMOJIS_BY_ALIAS.get(EmojiManager.trimAlias(alias).toLowerCase(Locale.ROOT));
    }

    private static String trimAlias(String alias) {
        int len = alias.length();
        return alias.substring(alias.charAt(0) == ':' ? 1 : 0, alias.charAt(len - 1) == ':' ? len - 1 : len);
    }

    @Nullable
    public static Emoji getByUnicode(@NotNull String unicode) {
        if (unicode == null) {
            return null;
        }
        return EMOJI_TRIE.getEmoji(unicode);
    }

    @NotNull
    public static List<Emoji> getAll() {
        return ALL_EMOJIS;
    }

    public static boolean isEmoji(@NotNull String string) {
        if (string == null) {
            return false;
        }
        EmojiParser.UnicodeCandidate unicodeCandidate = EmojiParser.getNextUnicodeCandidate(string.toCharArray(), 0);
        return unicodeCandidate != null && unicodeCandidate.getEmojiStartIndex() == 0 && unicodeCandidate.getFitzpatrickEndIndex() == string.length();
    }

    public static boolean containsEmoji(@NotNull String string) {
        if (string == null) {
            return false;
        }
        return EmojiParser.getNextUnicodeCandidate(string.toCharArray(), 0) != null;
    }

    public static boolean isOnlyEmojis(@NotNull String string) {
        return string != null && EmojiParser.removeAllEmojis(string).isEmpty();
    }

    @NotNull
    public static EmojiTrie.Matches isEmoji(@NotNull char[] sequence2) {
        return EMOJI_TRIE.isEmoji(sequence2);
    }

    @NotNull
    public static Set<String> getAllTags() {
        return Collections.unmodifiableSet(EMOJIS_BY_TAG.keySet());
    }

    static {
        EMOJIS_BY_ALIAS = new HashMap<String, Emoji>();
        EMOJIS_BY_TAG = new HashMap<String, Set<Emoji>>();
        EMOJIS_BY_CATEGORY = new HashMap<EmojiCategory, Set<Emoji>>();
        try (InputStream stream = EmojiLoader.class.getResourceAsStream(PATH);){
            List<Emoji> emojis = EmojiLoader.loadEmojis(stream);
            Map<String, Emoji> definitions = EmojiLoader.loadEmojiBundle();
            ALL_EMOJIS = emojis;
            ListIterator<Emoji> iter = emojis.listIterator();
            while (iter.hasNext()) {
                Emoji emoji = iter.next();
                Emoji definition = definitions.remove(emoji.getUnicode());
                if (definition != null) {
                    HashSet<String> joint = new HashSet<String>(emoji.aliases);
                    joint.addAll(definition.aliases);
                    emoji = emoji.setAliases(new ArrayList<String>(joint)).setFitzpatrick(definition.supportsFitzpatrick || emoji.supportsFitzpatrick);
                    iter.set(emoji);
                }
                EmojiManager.loadEmoji(emoji);
            }
            for (Map.Entry<String, Emoji> entry : definitions.entrySet()) {
                Emoji emoji = entry.getValue();
                EmojiManager.loadEmoji(emoji);
                emojis.add(emoji);
            }
            EMOJI_TRIE = new EmojiTrie(emojis);
            ALL_EMOJIS.sort((e1, e2) -> e2.getUnicode().length() - e1.getUnicode().length());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

