/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.dep.com.vdurmont.emoji;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.essentialsx.dep.com.vdurmont.emoji.Emoji;
import net.essentialsx.dep.com.vdurmont.emoji.EmojiCategory;
import net.essentialsx.dep.org.json.JSONArray;
import net.essentialsx.dep.org.json.JSONObject;
import net.essentialsx.dep.org.json.JSONTokener;
import org.jetbrains.annotations.NotNull;

public class EmojiLoader {
    private EmojiLoader() {
    }

    @NotNull
    public static List<Emoji> loadEmojis(@NotNull InputStream stream) throws IOException {
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        JSONArray emojisJSON = new JSONArray(new JSONTokener(reader));
        ArrayList<Emoji> emojis = new ArrayList<Emoji>(emojisJSON.length());
        for (int i = 0; i < emojisJSON.length(); ++i) {
            Emoji emoji = EmojiLoader.buildEmojiFromJSON(emojisJSON.getJSONObject(i));
            if (emoji == null) continue;
            emojis.add(emoji);
        }
        return emojis;
    }

    @NotNull
    public static Map<String, Emoji> loadEmojiBundle() throws IOException {
        try (InputStreamReader reader = new InputStreamReader(EmojiLoader.class.getResourceAsStream("/emoji-definitions.json"), StandardCharsets.UTF_8);){
            JSONObject file = new JSONObject(new JSONTokener(reader));
            JSONArray definitions = file.getJSONArray("emojiDefinitions");
            HashMap<String, Emoji> map = new HashMap<String, Emoji>(definitions.length() + 1);
            for (int i = 0; i < definitions.length(); ++i) {
                JSONObject json = definitions.getJSONObject(i);
                if (!json.has("category")) continue;
                String key = json.getString("surrogates");
                String primaryName = json.getString("primaryName");
                boolean supportsFitzpatrick = primaryName.contains("_tone");
                if (supportsFitzpatrick && map.containsKey(key = key.substring(0, key.length() - 2))) {
                    map.put(key, ((Emoji)map.get(key)).setFitzpatrick(true));
                    continue;
                }
                byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
                List<String> aliases = EmojiLoader.jsonArrayToStringList(json.getJSONArray("names"));
                List<String> tags = Collections.emptyList();
                EmojiCategory category = EmojiLoader.convertCategory(json.getString("category"));
                Emoji emoji = new Emoji("", supportsFitzpatrick, category, aliases, tags, bytes);
                map.put(key, emoji);
            }
            HashMap<String, Emoji> hashMap = map;
            return hashMap;
        }
    }

    private static EmojiCategory convertCategory(String raw) {
        for (EmojiCategory category : EmojiCategory.values()) {
            if (!category.name().equalsIgnoreCase(raw)) continue;
            return category;
        }
        return EmojiCategory.UNKNOWN;
    }

    protected static Emoji buildEmojiFromJSON(JSONObject json) {
        if (!json.has("emoji")) {
            return null;
        }
        byte[] bytes = json.getString("emoji").getBytes(StandardCharsets.UTF_8);
        boolean supportsFitzpatrick = json.optBoolean("skin_tones", false);
        List<String> aliases = EmojiLoader.jsonArrayToStringList(json.getJSONArray("aliases"));
        List<String> tags = EmojiLoader.jsonArrayToStringList(json.getJSONArray("tags"));
        String description = json.getString("description");
        EmojiCategory category = EmojiCategory.fromString(json.optString("category", "UNKNOWN"));
        return new Emoji(description, supportsFitzpatrick, category, aliases, tags, bytes);
    }

    private static List<String> jsonArrayToStringList(JSONArray array) {
        ArrayList<String> strings = new ArrayList<String>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            strings.add(array.getString(i));
        }
        return strings;
    }
}

