/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundMovePlayerStatusOnlyPacket
implements MinecraftPacket {
    private final boolean onGround;
    private final boolean horizontalCollision;

    public ServerboundMovePlayerStatusOnlyPacket(ByteBuf in) {
        short flags = in.readUnsignedByte();
        this.onGround = (flags & 1) != 0;
        this.horizontalCollision = (flags & 2) != 0;
    }

    @Override
    public void serialize(ByteBuf out) {
        int flags = 0;
        if (this.onGround) {
            flags |= 1;
        }
        if (this.horizontalCollision) {
            flags |= 2;
        }
        out.writeByte(flags);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean isHorizontalCollision() {
        return this.horizontalCollision;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundMovePlayerStatusOnlyPacket)) {
            return false;
        }
        ServerboundMovePlayerStatusOnlyPacket other = (ServerboundMovePlayerStatusOnlyPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOnGround() != other.isOnGround()) {
            return false;
        }
        return this.isHorizontalCollision() == other.isHorizontalCollision();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundMovePlayerStatusOnlyPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        result = result * 59 + (this.isHorizontalCollision() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundMovePlayerStatusOnlyPacket(onGround=" + this.isOnGround() + ", horizontalCollision=" + this.isHorizontalCollision() + ")";
    }

    public @NonNull ServerboundMovePlayerStatusOnlyPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ServerboundMovePlayerStatusOnlyPacket(onGround, this.horizontalCollision);
    }

    public @NonNull ServerboundMovePlayerStatusOnlyPacket withHorizontalCollision(boolean horizontalCollision) {
        return this.horizontalCollision == horizontalCollision ? this : new ServerboundMovePlayerStatusOnlyPacket(this.onGround, horizontalCollision);
    }

    public ServerboundMovePlayerStatusOnlyPacket(boolean onGround, boolean horizontalCollision) {
        this.onGround = onGround;
        this.horizontalCollision = horizontalCollision;
    }
}

