/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;

public class ToolData {
    private final List<Rule> rules;
    private final float defaultMiningSpeed;
    private final int damagePerBlock;

    public ToolData(List<Rule> rules, float defaultMiningSpeed, int damagePerBlock) {
        this.rules = List.copyOf(rules);
        this.defaultMiningSpeed = defaultMiningSpeed;
        this.damagePerBlock = damagePerBlock;
    }

    public static @NonNull ToolDataBuilder builder() {
        return new ToolDataBuilder();
    }

    public @NonNull ToolDataBuilder toBuilder() {
        return new ToolDataBuilder().rules(this.rules).defaultMiningSpeed(this.defaultMiningSpeed).damagePerBlock(this.damagePerBlock);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public float getDefaultMiningSpeed() {
        return this.defaultMiningSpeed;
    }

    public int getDamagePerBlock() {
        return this.damagePerBlock;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToolData)) {
            return false;
        }
        ToolData other = (ToolData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getDefaultMiningSpeed(), other.getDefaultMiningSpeed()) != 0) {
            return false;
        }
        if (this.getDamagePerBlock() != other.getDamagePerBlock()) {
            return false;
        }
        List<Rule> this$rules = this.getRules();
        List<Rule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ToolData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getDefaultMiningSpeed());
        result = result * 59 + this.getDamagePerBlock();
        List<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ToolData(rules=" + String.valueOf(this.getRules()) + ", defaultMiningSpeed=" + this.getDefaultMiningSpeed() + ", damagePerBlock=" + this.getDamagePerBlock() + ")";
    }

    public static class ToolDataBuilder {
        private List<Rule> rules;
        private float defaultMiningSpeed;
        private int damagePerBlock;

        ToolDataBuilder() {
        }

        public @NonNull ToolDataBuilder rules(List<Rule> rules) {
            this.rules = rules;
            return this;
        }

        public @NonNull ToolDataBuilder defaultMiningSpeed(float defaultMiningSpeed) {
            this.defaultMiningSpeed = defaultMiningSpeed;
            return this;
        }

        public @NonNull ToolDataBuilder damagePerBlock(int damagePerBlock) {
            this.damagePerBlock = damagePerBlock;
            return this;
        }

        public @NonNull ToolData build() {
            return new ToolData(this.rules, this.defaultMiningSpeed, this.damagePerBlock);
        }

        public @NonNull String toString() {
            return "ToolData.ToolDataBuilder(rules=" + String.valueOf(this.rules) + ", defaultMiningSpeed=" + this.defaultMiningSpeed + ", damagePerBlock=" + this.damagePerBlock + ")";
        }
    }

    public static class Rule {
        @lombok.NonNull
        private final HolderSet blocks;
        private final @Nullable Float speed;
        private final @Nullable Boolean correctForDrops;

        public static @NonNull RuleBuilder builder() {
            return new RuleBuilder();
        }

        public @NonNull RuleBuilder toBuilder() {
            return new RuleBuilder().blocks(this.blocks).speed(this.speed).correctForDrops(this.correctForDrops);
        }

        @lombok.NonNull
        public HolderSet getBlocks() {
            return this.blocks;
        }

        public @Nullable Float getSpeed() {
            return this.speed;
        }

        public @Nullable Boolean getCorrectForDrops() {
            return this.correctForDrops;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Rule)) {
                return false;
            }
            Rule other = (Rule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Float this$speed = this.getSpeed();
            Float other$speed = other.getSpeed();
            if (this$speed == null ? other$speed != null : !((Object)this$speed).equals(other$speed)) {
                return false;
            }
            Boolean this$correctForDrops = this.getCorrectForDrops();
            Boolean other$correctForDrops = other.getCorrectForDrops();
            if (this$correctForDrops == null ? other$correctForDrops != null : !((Object)this$correctForDrops).equals(other$correctForDrops)) {
                return false;
            }
            HolderSet this$blocks = this.getBlocks();
            HolderSet other$blocks = other.getBlocks();
            return !(this$blocks == null ? other$blocks != null : !((Object)this$blocks).equals(other$blocks));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Rule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Float $speed = this.getSpeed();
            result = result * 59 + ($speed == null ? 43 : ((Object)$speed).hashCode());
            Boolean $correctForDrops = this.getCorrectForDrops();
            result = result * 59 + ($correctForDrops == null ? 43 : ((Object)$correctForDrops).hashCode());
            HolderSet $blocks = this.getBlocks();
            result = result * 59 + ($blocks == null ? 43 : ((Object)$blocks).hashCode());
            return result;
        }

        public @NonNull String toString() {
            return "ToolData.Rule(blocks=" + String.valueOf(this.getBlocks()) + ", speed=" + this.getSpeed() + ", correctForDrops=" + this.getCorrectForDrops() + ")";
        }

        public Rule(@lombok.NonNull HolderSet blocks, @Nullable Float speed, @Nullable Boolean correctForDrops) {
            if (blocks == null) {
                throw new NullPointerException("blocks is marked non-null but is null");
            }
            this.blocks = blocks;
            this.speed = speed;
            this.correctForDrops = correctForDrops;
        }

        public static class RuleBuilder {
            private HolderSet blocks;
            private Float speed;
            private Boolean correctForDrops;

            RuleBuilder() {
            }

            public @NonNull RuleBuilder blocks(@lombok.NonNull HolderSet blocks) {
                if (blocks == null) {
                    throw new NullPointerException("blocks is marked non-null but is null");
                }
                this.blocks = blocks;
                return this;
            }

            public @NonNull RuleBuilder speed(@Nullable Float speed) {
                this.speed = speed;
                return this;
            }

            public @NonNull RuleBuilder correctForDrops(@Nullable Boolean correctForDrops) {
                this.correctForDrops = correctForDrops;
                return this;
            }

            public @NonNull Rule build() {
                return new Rule(this.blocks, this.speed, this.correctForDrops);
            }

            public @NonNull String toString() {
                return "ToolData.Rule.RuleBuilder(blocks=" + String.valueOf(this.blocks) + ", speed=" + this.speed + ", correctForDrops=" + this.correctForDrops + ")";
            }
        }
    }
}

