/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.jetbrains.annotations.Nullable;

public class AdventureModePredicate {
    private final List<BlockPredicate> predicates;
    private final boolean showInTooltip;

    public AdventureModePredicate(List<BlockPredicate> predicates, boolean showInTooltip) {
        this.predicates = List.copyOf(predicates);
        this.showInTooltip = showInTooltip;
    }

    public static @NonNull AdventureModePredicateBuilder builder() {
        return new AdventureModePredicateBuilder();
    }

    public @NonNull AdventureModePredicateBuilder toBuilder() {
        return new AdventureModePredicateBuilder().predicates(this.predicates).showInTooltip(this.showInTooltip);
    }

    public List<BlockPredicate> getPredicates() {
        return this.predicates;
    }

    public boolean isShowInTooltip() {
        return this.showInTooltip;
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdventureModePredicate)) {
            return false;
        }
        AdventureModePredicate other = (AdventureModePredicate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShowInTooltip() != other.isShowInTooltip()) {
            return false;
        }
        List<BlockPredicate> this$predicates = this.getPredicates();
        List<BlockPredicate> other$predicates = other.getPredicates();
        return !(this$predicates == null ? other$predicates != null : !((Object)this$predicates).equals(other$predicates));
    }

    protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
        return other instanceof AdventureModePredicate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShowInTooltip() ? 79 : 97);
        List<BlockPredicate> $predicates = this.getPredicates();
        result = result * 59 + ($predicates == null ? 43 : ((Object)$predicates).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "AdventureModePredicate(predicates=" + String.valueOf(this.getPredicates()) + ", showInTooltip=" + this.isShowInTooltip() + ")";
    }

    public static class AdventureModePredicateBuilder {
        private List<BlockPredicate> predicates;
        private boolean showInTooltip;

        AdventureModePredicateBuilder() {
        }

        public @NonNull AdventureModePredicateBuilder predicates(List<BlockPredicate> predicates) {
            this.predicates = predicates;
            return this;
        }

        public @NonNull AdventureModePredicateBuilder showInTooltip(boolean showInTooltip) {
            this.showInTooltip = showInTooltip;
            return this;
        }

        public @NonNull AdventureModePredicate build() {
            return new AdventureModePredicate(this.predicates, this.showInTooltip);
        }

        public @NonNull String toString() {
            return "AdventureModePredicate.AdventureModePredicateBuilder(predicates=" + String.valueOf(this.predicates) + ", showInTooltip=" + this.showInTooltip + ")";
        }
    }

    public static class PropertyMatcher {
        private final String name;
        @Nullable
        private final String value;
        @Nullable
        private final String minValue;
        @Nullable
        private final String maxValue;

        public static @NonNull PropertyMatcherBuilder builder() {
            return new PropertyMatcherBuilder();
        }

        public @NonNull PropertyMatcherBuilder toBuilder() {
            return new PropertyMatcherBuilder().name(this.name).value(this.value).minValue(this.minValue).maxValue(this.maxValue);
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        @Nullable
        public String getMinValue() {
            return this.minValue;
        }

        @Nullable
        public String getMaxValue() {
            return this.maxValue;
        }

        public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyMatcher)) {
                return false;
            }
            PropertyMatcher other = (PropertyMatcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$minValue = this.getMinValue();
            String other$minValue = other.getMinValue();
            if (this$minValue == null ? other$minValue != null : !this$minValue.equals(other$minValue)) {
                return false;
            }
            String this$maxValue = this.getMaxValue();
            String other$maxValue = other.getMaxValue();
            return !(this$maxValue == null ? other$maxValue != null : !this$maxValue.equals(other$maxValue));
        }

        protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
            return other instanceof PropertyMatcher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $minValue = this.getMinValue();
            result = result * 59 + ($minValue == null ? 43 : $minValue.hashCode());
            String $maxValue = this.getMaxValue();
            result = result * 59 + ($maxValue == null ? 43 : $maxValue.hashCode());
            return result;
        }

        public @NonNull String toString() {
            return "AdventureModePredicate.PropertyMatcher(name=" + this.getName() + ", value=" + this.getValue() + ", minValue=" + this.getMinValue() + ", maxValue=" + this.getMaxValue() + ")";
        }

        public PropertyMatcher(String name, @Nullable String value, @Nullable String minValue, @Nullable String maxValue) {
            this.name = name;
            this.value = value;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public static class PropertyMatcherBuilder {
            private String name;
            private String value;
            private String minValue;
            private String maxValue;

            PropertyMatcherBuilder() {
            }

            public @NonNull PropertyMatcherBuilder name(String name) {
                this.name = name;
                return this;
            }

            public @NonNull PropertyMatcherBuilder value(@Nullable String value) {
                this.value = value;
                return this;
            }

            public @NonNull PropertyMatcherBuilder minValue(@Nullable String minValue) {
                this.minValue = minValue;
                return this;
            }

            public @NonNull PropertyMatcherBuilder maxValue(@Nullable String maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            public @NonNull PropertyMatcher build() {
                return new PropertyMatcher(this.name, this.value, this.minValue, this.maxValue);
            }

            public @NonNull String toString() {
                return "AdventureModePredicate.PropertyMatcher.PropertyMatcherBuilder(name=" + this.name + ", value=" + this.value + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ")";
            }
        }
    }

    public static class BlockPredicate {
        @Nullable
        private final HolderSet blocks;
        @Nullable
        private final List<PropertyMatcher> properties;
        @Nullable
        private final NbtMap nbt;

        public BlockPredicate(@Nullable HolderSet blocks, List<PropertyMatcher> properties, @Nullable NbtMap nbt) {
            this.blocks = blocks;
            this.properties = List.copyOf(properties);
            this.nbt = nbt;
        }

        public static @NonNull BlockPredicateBuilder builder() {
            return new BlockPredicateBuilder();
        }

        public @NonNull BlockPredicateBuilder toBuilder() {
            return new BlockPredicateBuilder().blocks(this.blocks).properties(this.properties).nbt(this.nbt);
        }

        @Nullable
        public HolderSet getBlocks() {
            return this.blocks;
        }

        @Nullable
        public List<PropertyMatcher> getProperties() {
            return this.properties;
        }

        @Nullable
        public NbtMap getNbt() {
            return this.nbt;
        }

        public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockPredicate)) {
                return false;
            }
            BlockPredicate other = (BlockPredicate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            HolderSet this$blocks = this.getBlocks();
            HolderSet other$blocks = other.getBlocks();
            if (this$blocks == null ? other$blocks != null : !((Object)this$blocks).equals(other$blocks)) {
                return false;
            }
            List<PropertyMatcher> this$properties = this.getProperties();
            List<PropertyMatcher> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            NbtMap this$nbt = this.getNbt();
            NbtMap other$nbt = other.getNbt();
            return !(this$nbt == null ? other$nbt != null : !((Object)this$nbt).equals(other$nbt));
        }

        protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
            return other instanceof BlockPredicate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            HolderSet $blocks = this.getBlocks();
            result = result * 59 + ($blocks == null ? 43 : ((Object)$blocks).hashCode());
            List<PropertyMatcher> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            NbtMap $nbt = this.getNbt();
            result = result * 59 + ($nbt == null ? 43 : ((Object)$nbt).hashCode());
            return result;
        }

        public @NonNull String toString() {
            return "AdventureModePredicate.BlockPredicate(blocks=" + String.valueOf(this.getBlocks()) + ", properties=" + String.valueOf(this.getProperties()) + ", nbt=" + String.valueOf(this.getNbt()) + ")";
        }

        public static class BlockPredicateBuilder {
            private HolderSet blocks;
            private List<PropertyMatcher> properties;
            private NbtMap nbt;

            BlockPredicateBuilder() {
            }

            public @NonNull BlockPredicateBuilder blocks(@Nullable HolderSet blocks) {
                this.blocks = blocks;
                return this;
            }

            public @NonNull BlockPredicateBuilder properties(@Nullable List<PropertyMatcher> properties) {
                this.properties = properties;
                return this;
            }

            public @NonNull BlockPredicateBuilder nbt(@Nullable NbtMap nbt) {
                this.nbt = nbt;
                return this;
            }

            public @NonNull BlockPredicate build() {
                return new BlockPredicate(this.blocks, this.properties, this.nbt);
            }

            public @NonNull String toString() {
                return "AdventureModePredicate.BlockPredicate.BlockPredicateBuilder(blocks=" + String.valueOf(this.blocks) + ", properties=" + String.valueOf(this.properties) + ", nbt=" + String.valueOf(this.nbt) + ")";
            }
        }
    }
}

