/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.inventory;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class VillagerTrade {
    @lombok.NonNull
    private final ItemStack firstInput;
    private final @Nullable ItemStack secondInput;
    private final @Nullable ItemStack output;
    private final boolean tradeDisabled;
    private final int numUses;
    private final int maxUses;
    private final int xp;
    private final int specialPrice;
    private final float priceMultiplier;
    private final int demand;

    @lombok.NonNull
    public ItemStack getFirstInput() {
        return this.firstInput;
    }

    public @Nullable ItemStack getSecondInput() {
        return this.secondInput;
    }

    public @Nullable ItemStack getOutput() {
        return this.output;
    }

    public boolean isTradeDisabled() {
        return this.tradeDisabled;
    }

    public int getNumUses() {
        return this.numUses;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public int getXp() {
        return this.xp;
    }

    public int getSpecialPrice() {
        return this.specialPrice;
    }

    public float getPriceMultiplier() {
        return this.priceMultiplier;
    }

    public int getDemand() {
        return this.demand;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VillagerTrade)) {
            return false;
        }
        VillagerTrade other = (VillagerTrade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTradeDisabled() != other.isTradeDisabled()) {
            return false;
        }
        if (this.getNumUses() != other.getNumUses()) {
            return false;
        }
        if (this.getMaxUses() != other.getMaxUses()) {
            return false;
        }
        if (this.getXp() != other.getXp()) {
            return false;
        }
        if (this.getSpecialPrice() != other.getSpecialPrice()) {
            return false;
        }
        if (Float.compare(this.getPriceMultiplier(), other.getPriceMultiplier()) != 0) {
            return false;
        }
        if (this.getDemand() != other.getDemand()) {
            return false;
        }
        ItemStack this$firstInput = this.getFirstInput();
        ItemStack other$firstInput = other.getFirstInput();
        if (this$firstInput == null ? other$firstInput != null : !((Object)this$firstInput).equals(other$firstInput)) {
            return false;
        }
        ItemStack this$secondInput = this.getSecondInput();
        ItemStack other$secondInput = other.getSecondInput();
        if (this$secondInput == null ? other$secondInput != null : !((Object)this$secondInput).equals(other$secondInput)) {
            return false;
        }
        ItemStack this$output = this.getOutput();
        ItemStack other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !((Object)this$output).equals(other$output));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof VillagerTrade;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTradeDisabled() ? 79 : 97);
        result = result * 59 + this.getNumUses();
        result = result * 59 + this.getMaxUses();
        result = result * 59 + this.getXp();
        result = result * 59 + this.getSpecialPrice();
        result = result * 59 + Float.floatToIntBits(this.getPriceMultiplier());
        result = result * 59 + this.getDemand();
        ItemStack $firstInput = this.getFirstInput();
        result = result * 59 + ($firstInput == null ? 43 : ((Object)$firstInput).hashCode());
        ItemStack $secondInput = this.getSecondInput();
        result = result * 59 + ($secondInput == null ? 43 : ((Object)$secondInput).hashCode());
        ItemStack $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "VillagerTrade(firstInput=" + String.valueOf(this.getFirstInput()) + ", secondInput=" + String.valueOf(this.getSecondInput()) + ", output=" + String.valueOf(this.getOutput()) + ", tradeDisabled=" + this.isTradeDisabled() + ", numUses=" + this.getNumUses() + ", maxUses=" + this.getMaxUses() + ", xp=" + this.getXp() + ", specialPrice=" + this.getSpecialPrice() + ", priceMultiplier=" + this.getPriceMultiplier() + ", demand=" + this.getDemand() + ")";
    }

    public VillagerTrade(@lombok.NonNull ItemStack firstInput, @Nullable ItemStack secondInput, @Nullable ItemStack output, boolean tradeDisabled, int numUses, int maxUses, int xp, int specialPrice, float priceMultiplier, int demand) {
        if (firstInput == null) {
            throw new NullPointerException("firstInput is marked non-null but is null");
        }
        this.firstInput = firstInput;
        this.secondInput = secondInput;
        this.output = output;
        this.tradeDisabled = tradeDisabled;
        this.numUses = numUses;
        this.maxUses = maxUses;
        this.xp = xp;
        this.specialPrice = specialPrice;
        this.priceMultiplier = priceMultiplier;
        this.demand = demand;
    }
}

