/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.attribute;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.ModifierOperation;

public class AttributeModifier {
    @lombok.NonNull
    private final Key id;
    private final double amount;
    @lombok.NonNull
    private final ModifierOperation operation;

    public AttributeModifier(@lombok.NonNull Key id, double amount, @lombok.NonNull ModifierOperation operation) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.id = id;
        this.amount = amount;
        this.operation = operation;
    }

    @lombok.NonNull
    public Key getId() {
        return this.id;
    }

    public double getAmount() {
        return this.amount;
    }

    @lombok.NonNull
    public ModifierOperation getOperation() {
        return this.operation;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeModifier)) {
            return false;
        }
        AttributeModifier other = (AttributeModifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        Key this$id = this.getId();
        Key other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ModifierOperation this$operation = this.getOperation();
        ModifierOperation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AttributeModifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        Key $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ModifierOperation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "AttributeModifier(id=" + String.valueOf(this.getId()) + ", amount=" + this.getAmount() + ", operation=" + String.valueOf((Object)this.getOperation()) + ")";
    }
}

