/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.session;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.network.BuiltinFlags;
import org.geysermc.mcprotocollib.network.ClientSession;
import org.geysermc.mcprotocollib.network.ProxyInfo;
import org.geysermc.mcprotocollib.network.helper.NettyHelper;
import org.geysermc.mcprotocollib.network.helper.TransportHelper;
import org.geysermc.mcprotocollib.network.netty.MinecraftChannelInitializer;
import org.geysermc.mcprotocollib.network.packet.PacketProtocol;
import org.geysermc.mcprotocollib.network.session.NetworkSession;

public class ClientNetworkSession
extends NetworkSession
implements ClientSession {
    private static EventLoopGroup EVENT_LOOP_GROUP;
    private static final int SHUTDOWN_QUIET_PERIOD_MS = 100;
    private static final int SHUTDOWN_TIMEOUT_MS = 500;
    protected final SocketAddress bindAddress;
    protected final ProxyInfo proxy;

    public ClientNetworkSession(@NonNull SocketAddress remoteAddress, @NonNull PacketProtocol protocol, @NonNull Executor packetHandlerExecutor, @Nullable SocketAddress bindAddress, @Nullable ProxyInfo proxy) {
        super(remoteAddress, protocol, packetHandlerExecutor);
        this.bindAddress = bindAddress;
        this.proxy = proxy;
    }

    @Override
    public void connect(boolean wait) {
        if (this.disconnected) {
            throw new IllegalStateException("Session has already been disconnected.");
        }
        EventLoopGroup eventLoopGroup = this.getEventLoopGroup();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(this.getChannelFactory())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((Integer)this.getFlag(BuiltinFlags.CLIENT_CONNECT_TIMEOUT, 30) * 1000))).group(eventLoopGroup)).remoteAddress(NettyHelper.resolveAddress(this, this.remoteAddress)).localAddress(this.bindAddress)).handler(this.getChannelHandler());
        this.setOptions(bootstrap);
        CompletableFuture handleFuture = new CompletableFuture();
        bootstrap.connect().addListener(futureListener -> {
            if (!futureListener.isSuccess()) {
                this.exceptionCaught(null, futureListener.cause());
            }
            handleFuture.complete(null);
        });
        if (wait) {
            handleFuture.join();
        }
    }

    @Override
    public @Nullable ProxyInfo getProxy() {
        return this.proxy;
    }

    protected EventLoopGroup getEventLoopGroup() {
        ClientNetworkSession.createEventLoopGroup();
        return EVENT_LOOP_GROUP;
    }

    protected ChannelFactory<? extends Channel> getChannelFactory() {
        return TransportHelper.TRANSPORT_TYPE.socketChannelFactory();
    }

    protected void setOptions(Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.IP_TOS, (Object)24);
        if (((Boolean)this.getFlag(BuiltinFlags.TCP_FAST_OPEN, false)).booleanValue() && TransportHelper.TRANSPORT_TYPE.supportsTcpFastOpenClient()) {
            bootstrap.option(ChannelOption.TCP_FASTOPEN_CONNECT, (Object)true);
        }
    }

    protected ChannelHandler getChannelHandler() {
        return new MinecraftChannelInitializer<ClientNetworkSession>(channel -> {
            PacketProtocol protocol = this.getPacketProtocol();
            protocol.newClientSession(this);
            return this;
        }, true){

            @Override
            public void initChannel(@NonNull Channel channel) throws Exception {
                NettyHelper.addProxy(ClientNetworkSession.this.proxy, channel.pipeline());
                NettyHelper.initializeHAProxySupport(ClientNetworkSession.this, channel);
                super.initChannel(channel);
            }
        };
    }

    private static void createEventLoopGroup() {
        if (EVENT_LOOP_GROUP != null) {
            return;
        }
        EVENT_LOOP_GROUP = TransportHelper.TRANSPORT_TYPE.eventLoopGroupFactory().apply(ClientNetworkSession.newThreadFactory());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> EVENT_LOOP_GROUP.shutdownGracefully(100L, 500L, TimeUnit.MILLISECONDS)));
    }

    protected static ThreadFactory newThreadFactory() {
        return new DefaultThreadFactory(ClientNetworkSession.class, true);
    }
}

