/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.FakeHeadProvider;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Equipment;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundSetEquipmentPacket;

@Translator(packet=ClientboundSetEquipmentPacket.class)
public class JavaSetEquipmentTranslator
extends PacketTranslator<ClientboundSetEquipmentPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetEquipmentPacket packet) {
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            session.getGeyser().getLogger().debug("Attempted to add armor to a non-living entity type (" + entity.getDefinition().entityType().name() + ").");
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        boolean armorUpdated = false;
        boolean mainHandUpdated = false;
        boolean offHandUpdated = false;
        block9: for (Equipment equipment : packet.getEquipment()) {
            ItemStack stack = equipment.getItem();
            switch (equipment.getSlot()) {
                case HELMET: {
                    ItemStack javaItem = equipment.getItem();
                    if (livingEntity instanceof PlayerEntity && javaItem != null && javaItem.getId() == Items.PLAYER_HEAD.javaId() && javaItem.getDataComponentsPatch() != null) {
                        FakeHeadProvider.setHead(session, (PlayerEntity)livingEntity, GeyserItemStack.from(javaItem).getComponent(DataComponentTypes.PROFILE));
                    } else {
                        FakeHeadProvider.restoreOriginalSkin(session, livingEntity);
                    }
                    livingEntity.setHelmet(stack);
                    armorUpdated = true;
                    continue block9;
                }
                case CHESTPLATE: {
                    livingEntity.setChestplate(stack);
                    armorUpdated = true;
                    continue block9;
                }
                case BODY: {
                    livingEntity.setBody(stack);
                    armorUpdated = true;
                    continue block9;
                }
                case LEGGINGS: {
                    livingEntity.setLeggings(stack);
                    armorUpdated = true;
                    continue block9;
                }
                case BOOTS: {
                    livingEntity.setBoots(stack);
                    armorUpdated = true;
                    continue block9;
                }
                case MAIN_HAND: {
                    livingEntity.setHand(stack);
                    mainHandUpdated = true;
                    continue block9;
                }
                case OFF_HAND: {
                    livingEntity.setOffhand(stack);
                    offHandUpdated = true;
                }
            }
        }
        if (armorUpdated) {
            livingEntity.updateArmor(session);
        }
        if (mainHandUpdated) {
            livingEntity.updateMainHand(session);
        }
        if (offHandUpdated) {
            livingEntity.updateOffHand(session);
        }
    }
}

