/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import java.util.Optional;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.packet.AnimateEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.AnimatePacket;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.SpawnParticleEffectPacket;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Animation;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundAnimatePacket;

@Translator(packet=ClientboundAnimatePacket.class)
public class JavaAnimateTranslator
extends PacketTranslator<ClientboundAnimatePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundAnimatePacket packet) {
        Animation animation = packet.getAnimation();
        if (animation == null) {
            return;
        }
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        AnimatePacket animatePacket = new AnimatePacket();
        animatePacket.setRuntimeEntityId(entity.getGeyserId());
        switch (animation) {
            case SWING_ARM: {
                LivingEntity livingEntity;
                if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).useArmSwingAttack()) {
                    EntityEventPacket entityEventPacket = new EntityEventPacket();
                    entityEventPacket.setRuntimeEntityId(entity.getGeyserId());
                    entityEventPacket.setType(EntityEventType.ATTACK_START);
                    session.sendUpstreamPacket(entityEventPacket);
                    return;
                }
                animatePacket.setAction(AnimatePacket.Action.SWING_ARM);
                if (entity.getEntityId() != session.getPlayerEntity().getEntityId()) break;
                session.activateArmAnimationTicking();
                break;
            }
            case SWING_OFFHAND: {
                AnimateEntityPacket offHandPacket = new AnimateEntityPacket();
                offHandPacket.setAnimation("animation.player.attack.rotations.offhand");
                offHandPacket.setNextState("default");
                offHandPacket.setBlendOutTime(0.0f);
                offHandPacket.setStopExpression("query.any_animation_finished");
                offHandPacket.setController("__runtime_controller");
                offHandPacket.getRuntimeEntityIds().add(entity.getGeyserId());
                session.sendUpstreamPacket(offHandPacket);
                return;
            }
            case CRITICAL_HIT: {
                animatePacket.setAction(AnimatePacket.Action.CRITICAL_HIT);
                break;
            }
            case ENCHANTMENT_CRITICAL_HIT: {
                animatePacket.setAction(AnimatePacket.Action.MAGIC_CRITICAL_HIT);
                SpawnParticleEffectPacket stringPacket = new SpawnParticleEffectPacket();
                stringPacket.setIdentifier("geyseropt:enchanted_hit_multiple");
                stringPacket.setDimensionId(DimensionUtils.javaToBedrock(session));
                stringPacket.setPosition(Vector3f.ZERO);
                stringPacket.setUniqueEntityId(entity.getGeyserId());
                stringPacket.setMolangVariablesJson(Optional.empty());
                session.sendUpstreamPacket(stringPacket);
                break;
            }
            case LEAVE_BED: {
                animatePacket.setAction(AnimatePacket.Action.WAKE_UP);
                break;
            }
            default: {
                session.getGeyser().getLogger().debug("Unhandled java animation: " + String.valueOf((Object)animation));
                return;
            }
        }
        session.sendUpstreamPacket(animatePacket);
    }
}

