/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.level.block.property.ChestType;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.CHEST, BlockEntityType.TRAPPED_CHEST})
public class DoubleChestBlockEntityTranslator
extends BlockEntityTranslator
implements RequiresBlockState {
    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, BlockState blockState) {
        if (blockState.getValue(Properties.CHEST_TYPE) != ChestType.SINGLE) {
            int x = (Integer)bedrockNbt.get("x");
            int z = (Integer)bedrockNbt.get("z");
            DoubleChestBlockEntityTranslator.translateChestValue(bedrockNbt, blockState, x, z);
        }
    }

    public static void translateChestValue(NbtMapBuilder builder, BlockState state, int x, int z) {
        Direction facing = state.getValue(Properties.HORIZONTAL_FACING);
        boolean isLeft = state.getValue(Properties.CHEST_TYPE) == ChestType.LEFT;
        switch (facing) {
            case EAST: {
                z += isLeft ? 1 : -1;
                break;
            }
            case WEST: {
                z += isLeft ? -1 : 1;
                break;
            }
            case SOUTH: {
                x += isLeft ? -1 : 1;
                break;
            }
            case NORTH: {
                x += isLeft ? 1 : -1;
            }
        }
        builder.putInt("pairx", x);
        builder.putInt("pairz", z);
        if (!isLeft) {
            builder.putInt("pairlead", 1);
        }
    }
}

