/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

public abstract class BlockEntityTranslator {
    protected BlockEntityTranslator() {
    }

    public abstract void translateTag(GeyserSession var1, NbtMapBuilder var2, NbtMap var3, BlockState var4);

    public NbtMap getBlockEntityTag(GeyserSession session, BlockEntityType type, int x, int y, int z, @Nullable NbtMap javaNbt, BlockState blockState) {
        NbtMapBuilder tagBuilder = BlockEntityTranslator.getConstantBedrockTag(type, x, y, z);
        if (javaNbt != null || this instanceof RequiresBlockState) {
            this.translateTag(session, tagBuilder, javaNbt, blockState);
        }
        return tagBuilder.build();
    }

    public static NbtMapBuilder getConstantBedrockTag(BlockEntityType type, int x, int y, int z) {
        return BlockEntityTranslator.getConstantBedrockTag(BlockEntityUtils.getBedrockBlockEntityId(type), x, y, z);
    }

    public static NbtMapBuilder getConstantBedrockTag(String bedrockId, Vector3i position) {
        return BlockEntityTranslator.getConstantBedrockTag(bedrockId, position.getX(), position.getY(), position.getZ());
    }

    public static NbtMapBuilder getConstantBedrockTag(String bedrockId, int x, int y, int z) {
        return NbtMap.builder().putInt("x", x).putInt("y", y).putInt("z", z).putString("id", bedrockId);
    }
}

