/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.holder.BlockInventoryHolder;
import org.geysermc.geyser.inventory.holder.InventoryHolder;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.BaseInventoryTranslator;

public abstract class AbstractBlockInventoryTranslator
extends BaseInventoryTranslator {
    private final InventoryHolder holder;
    private final InventoryUpdater updater;

    public AbstractBlockInventoryTranslator(int size, Block javaBlock, ContainerType containerType, InventoryUpdater updater, Block ... additionalValidBlocks) {
        this(size, javaBlock.defaultBlockState(), containerType, updater, additionalValidBlocks);
    }

    public AbstractBlockInventoryTranslator(int size, BlockState javaBlockState, ContainerType containerType, InventoryUpdater updater, Block ... additionalValidBlocks) {
        super(size);
        this.holder = new BlockInventoryHolder(javaBlockState, containerType, additionalValidBlocks);
        this.updater = updater;
    }

    public AbstractBlockInventoryTranslator(int size, InventoryHolder holder, InventoryUpdater updater) {
        super(size);
        this.holder = holder;
        this.updater = updater;
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Inventory inventory) {
        return this.holder.prepareInventory(this, session, inventory);
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
        this.holder.openInventory(this, session, inventory);
    }

    @Override
    public void closeInventory(GeyserSession session, Inventory inventory) {
        this.holder.closeInventory(this, session, inventory, this.closeContainerType(inventory));
    }

    @Override
    public void updateInventory(GeyserSession session, Inventory inventory) {
        this.updater.updateInventory(this, session, inventory);
    }

    @Override
    public void updateSlot(GeyserSession session, Inventory inventory, int slot) {
        this.updater.updateSlot(this, session, inventory, slot);
    }

    public abstract @Nullable ContainerType closeContainerType(Inventory var1);
}

