/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtUtils;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemCategory;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemGroup;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.populator.ItemRegistryPopulator;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.registry.type.GeyserMappingItem;

public class CreativeItemRegistryPopulator {
    private static final List<BiPredicate<String, Integer>> JAVA_ONLY_ITEM_FILTER = List.of((identifier, data) -> identifier.equals("minecraft:empty_map") && data == 2);

    static List<CreativeItemGroup> readCreativeItemGroups(ItemRegistryPopulator.PaletteVersion palette, List<CreativeItemData> creativeItemData) {
        JsonNode creativeItemEntries;
        GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
        try (InputStream stream = bootstrap.getResourceOrThrow(String.format("bedrock/creative_items.%s.json", palette.version()));){
            creativeItemEntries = GeyserImpl.JSON_MAPPER.readTree(stream).get("groups");
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load creative item groups", e);
        }
        ArrayList<CreativeItemGroup> creativeItemGroups = new ArrayList<CreativeItemGroup>();
        for (JsonNode creativeItemEntry : creativeItemEntries) {
            CreativeItemCategory category = CreativeItemCategory.valueOf(creativeItemEntry.get("category").asText().toUpperCase(Locale.ROOT));
            String name = creativeItemEntry.get("name").asText();
            JsonNode icon = creativeItemEntry.get("icon");
            String identifier = icon.get("id").asText();
            ItemData itemData = identifier.equals("minecraft:air") ? ItemData.AIR : creativeItemData.stream().map(CreativeItemData::getItem).filter(item -> item.getDefinition().getIdentifier().equals(identifier)).findFirst().orElseThrow();
            creativeItemGroups.add(new CreativeItemGroup(category, name, itemData));
        }
        return creativeItemGroups;
    }

    static void populate(ItemRegistryPopulator.PaletteVersion palette, Map<String, ItemDefinition> definitions, Map<String, GeyserMappingItem> items, BiConsumer<ItemData.Builder, Integer> itemConsumer) {
        JsonNode creativeItemEntries;
        GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
        try (InputStream stream = bootstrap.getResourceOrThrow(String.format("bedrock/creative_items.%s.json", palette.version()));){
            creativeItemEntries = GeyserImpl.JSON_MAPPER.readTree(stream).get("items");
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load creative items", e);
        }
        BlockMappings blockMappings = BlockRegistries.BLOCKS.forVersion(palette.protocolVersion());
        for (JsonNode itemNode : creativeItemEntries) {
            ItemData.Builder itemBuilder = CreativeItemRegistryPopulator.createItemData(itemNode, items, blockMappings, definitions);
            if (itemBuilder == null) continue;
            int groupId = itemNode.get("groupId") != null ? itemNode.get("groupId").asInt() : 0;
            itemConsumer.accept(itemBuilder, groupId);
        }
    }

    private static @Nullable ItemData.Builder createItemData(JsonNode itemNode, Map<String, GeyserMappingItem> items, BlockMappings blockMappings, Map<String, ItemDefinition> definitions) {
        ItemDefinition definition;
        JsonNode nbtNode;
        JsonNode countNode;
        JsonNode damageNode;
        int count = 1;
        int damage = 0;
        NbtMap tag = null;
        String identifier = itemNode.get("id").textValue();
        for (BiPredicate<String, Integer> predicate : JAVA_ONLY_ITEM_FILTER) {
            if (!predicate.test(identifier, damage)) continue;
            return null;
        }
        if (!items.containsKey(identifier) && !identifier.equals("minecraft:lodestone_compass")) {
            boolean found = false;
            for (GeyserMappingItem mapping : items.values()) {
                if (!mapping.getBedrockIdentifier().equals(identifier)) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        }
        if ((damageNode = itemNode.get("damage")) != null) {
            damage = damageNode.asInt();
        }
        if ((countNode = itemNode.get("count")) != null) {
            count = countNode.asInt();
        }
        GeyserBedrockBlock blockDefinition = null;
        JsonNode blockStateNode = itemNode.get("block_state_b64");
        if (blockStateNode != null) {
            byte[] bytes = Base64.getDecoder().decode(blockStateNode.asText());
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try {
                NbtMap stateTag = (NbtMap)NbtUtils.createReaderLE(bais).readTag();
                NbtMapBuilder builder = stateTag.toBuilder();
                builder.remove("name_hash");
                builder.remove("network_id");
                builder.remove("version");
                builder.remove("block_id");
                blockDefinition = blockMappings.getDefinition(builder.build());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((nbtNode = itemNode.get("nbt_b64")) != null) {
            byte[] bytes = Base64.getDecoder().decode(nbtNode.asText());
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try {
                tag = (NbtMap)NbtUtils.createReaderLE(bais).readTag();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((definition = definitions.get(identifier)) == null) {
            GeyserImpl.getInstance().getLogger().debug("Unknown item definition with identifier " + identifier + " when loading creative items!");
            return null;
        }
        return ItemData.builder().definition(definition).damage(damage).count(count).tag(tag).blockDefinition(blockDefinition);
    }
}

