/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.lifecycle.GeyserLoadResourcePacksEvent;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.pack.GeyserResourcePack;
import org.geysermc.geyser.pack.GeyserResourcePackManifest;
import org.geysermc.geyser.pack.SkullResourcePackManager;
import org.geysermc.geyser.pack.path.GeyserPathPackCodec;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;

public class ResourcePackLoader
implements RegistryLoader<Path, Map<UUID, ResourcePack>> {
    static final PathMatcher PACK_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.{zip,mcpack}");
    private static final boolean SHOW_RESOURCE_PACK_LENGTH_WARNING = Boolean.parseBoolean(System.getProperty("Geyser.ShowResourcePackLengthWarning", "true"));

    @Override
    public Map<UUID, ResourcePack> load(Path directory) {
        ArrayList<Path> resourcePacks;
        HashMap<UUID, ResourcePack> packMap = new HashMap<UUID, ResourcePack>();
        if (!Files.exists(directory, new LinkOption[0])) {
            try {
                Files.createDirectory(directory, new FileAttribute[0]);
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().error("Could not create packs directory", e);
            }
        }
        try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
            resourcePacks = stream.filter(PACK_MATCHER::matches).collect(Collectors.toCollection(ArrayList::new));
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Could not list packs directory", e);
            resourcePacks = new ArrayList<Path>();
        }
        Path skullResourcePack = SkullResourcePackManager.createResourcePack();
        if (skullResourcePack != null) {
            resourcePacks.add(skullResourcePack);
        }
        GeyserLoadResourcePacksEvent event = new GeyserLoadResourcePacksEvent(resourcePacks);
        GeyserImpl.getInstance().eventBus().fire(event);
        for (Path path : event.resourcePacks()) {
            try {
                GeyserResourcePack pack = ResourcePackLoader.readPack(path);
                packMap.put(pack.manifest().header().uuid(), pack);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return packMap;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static GeyserResourcePack readPack(Path path) throws IllegalArgumentException {
        if (!path.getFileName().toString().endsWith(".mcpack") && !path.getFileName().toString().endsWith(".zip")) {
            throw new IllegalArgumentException("Resource pack " + String.valueOf(path.getFileName()) + " must be a .zip or .mcpack file!");
        }
        AtomicReference manifestReference = new AtomicReference();
        try (ZipFile zip = new ZipFile(path.toFile());){
            GeyserResourcePack geyserResourcePack;
            block15: {
                Stream<? extends ZipEntry> stream = zip.stream();
                try {
                    stream.forEach(x -> {
                        String name = x.getName();
                        if (SHOW_RESOURCE_PACK_LENGTH_WARNING && name.length() >= 80) {
                            GeyserImpl.getInstance().getLogger().warning("The resource pack " + String.valueOf(path.getFileName()) + " has a file in it that meets or exceeds 80 characters in its path (" + name + ", " + name.length() + " characters long). This will cause problems on some Bedrock platforms. Please rename it to be shorter, or reduce the amount of folders needed to get to the file.");
                        }
                        if (name.contains("manifest.json")) {
                            try {
                                GeyserResourcePackManifest manifest = FileUtils.loadJson(zip.getInputStream((ZipEntry)x), GeyserResourcePackManifest.class);
                                if (manifest.header().uuid() != null) {
                                    manifestReference.set(manifest);
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    GeyserResourcePackManifest manifest = (GeyserResourcePackManifest)manifestReference.get();
                    if (manifest == null) {
                        throw new IllegalArgumentException(String.valueOf(path.getFileName()) + " does not contain a valid pack_manifest.json or manifest.json");
                    }
                    Path keyFile = path.resolveSibling(path.getFileName().toString() + ".key");
                    String contentKey = Files.exists(keyFile, new LinkOption[0]) ? Files.readString(keyFile, StandardCharsets.UTF_8) : "";
                    geyserResourcePack = new GeyserResourcePack(new GeyserPathPackCodec(path), manifest, contentKey);
                    if (stream == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return geyserResourcePack;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(GeyserLocale.getLocaleStringLog("geyser.resource_pack.broken", path.getFileName()), e);
        }
    }
}

