/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.shaded.me.lucko.commodore.file;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import org.geysermc.geyser.platform.spigot.shaded.me.lucko.commodore.file.AbstractIterator;
import org.geysermc.geyser.platform.spigot.shaded.me.lucko.commodore.file.ParseException;
import org.geysermc.geyser.platform.spigot.shaded.me.lucko.commodore.file.Token;
import org.geysermc.geyser.platform.spigot.shaded.me.lucko.commodore.file.TokenStream;

class Lexer
extends AbstractIterator<Token>
implements TokenStream {
    private final StreamTokenizer tokenizer;
    private boolean end = false;

    Lexer(Reader reader) {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(33, 126);
        this.tokenizer.quoteChar(34);
        this.tokenizer.whitespaceChars(0, 32);
        "{};".chars().forEach(this.tokenizer::ordinaryChar);
        this.tokenizer.slashSlashComments(true);
        this.tokenizer.slashStarComments(true);
    }

    @Override
    protected Token computeNext() throws ParseException {
        if (this.end) {
            return (Token)this.endOfData();
        }
        try {
            int token = this.tokenizer.nextToken();
            switch (token) {
                case -1: {
                    this.end = true;
                    return Token.ConstantToken.EOF;
                }
                case -3: {
                    return new Token.StringToken(this.tokenizer.sval);
                }
                case 123: {
                    return Token.ConstantToken.OPEN_BRACKET;
                }
                case 125: {
                    return Token.ConstantToken.CLOSE_BRACKET;
                }
                case 59: {
                    return Token.ConstantToken.SEMICOLON;
                }
            }
            throw this.createException("Unknown token: " + (char)token + "(" + token + ")");
        }
        catch (IOException e) {
            throw this.createException(e);
        }
    }

    @Override
    public ParseException createException(String message) {
        return new ParseException(message, this.tokenizer.lineno());
    }

    @Override
    public ParseException createException(Throwable cause) {
        return new ParseException(cause, this.tokenizer.lineno());
    }

    @Override
    public ParseException createException(String message, Throwable cause) {
        return new ParseException(message, cause, this.tokenizer.lineno());
    }
}

