/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.command;

import java.lang.reflect.Field;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.CommandManager;

public class SpigotCommandRegistry
extends CommandRegistry {
    private final CommandMap commandMap;

    public SpigotCommandRegistry(GeyserImpl geyser, CommandManager<GeyserCommandSource> cloud) {
        super(geyser, cloud);
        CommandMap commandMap = null;
        try {
            Server.class.getMethod("getCommandMap", new Class[0]);
            commandMap = Bukkit.getServer().getCommandMap();
        }
        catch (NoSuchMethodException e) {
            try {
                Field cmdMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                cmdMapField.setAccessible(true);
                commandMap = (CommandMap)cmdMapField.get(Bukkit.getServer());
            }
            catch (Exception ex) {
                geyser.getLogger().error("Failed to get Spigot's CommandMap", ex);
            }
        }
        this.commandMap = commandMap;
    }

    @Override
    public @NonNull String description(@NonNull String command, @NonNull String locale) {
        Command cmd;
        String description = super.description(command, locale);
        if (!description.isBlank()) {
            return description;
        }
        if (this.commandMap != null && (cmd = this.commandMap.getCommand(command)) != null) {
            return cmd.getDescription();
        }
        return "";
    }
}

